/*
 * Decompiled with CFR 0.152.
 */
package org.drupal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.drupal.IPropertyParser;
import org.drupal.ModuleProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInfoParser {
    Pattern pattern = Pattern.compile("\\s*((?:[^=;\\[\\]]|\\[[^\\[\\]]*\\])+?)\\s*=\\s*(?:([^\\r\\n]*?))\\s*");
    protected List<String> dependencies = new ArrayList<String>();

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void read(File file) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = reader.readLine()) != null) {
            ModuleProperty moduleProperty;
            Matcher matcher = this.pattern.matcher(line);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            List<String> keys = Arrays.asList(StringUtils.stripStart((String)key, (String)"]").split("\\]?\\["));
            if (keys.isEmpty() || (moduleProperty = ModuleProperty.parse(keys.get(0))) == null) continue;
            IPropertyParser propertyParser = moduleProperty.getParser(this);
            propertyParser.parse(keys, value);
        }
    }
}

