/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4groovy;

import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.itransformers.expect4groovy.Expect4Groovy;
import net.itransformers.expect4java.cliconnection.CLIConnection;
import net.itransformers.expect4java.cliconnection.impl.EchoCLIConnection;
import net.itransformers.expect4java.cliconnection.impl.RawSocketCLIConnection;
import net.itransformers.expect4java.cliconnection.impl.SshCLIConnection;
import net.itransformers.expect4java.cliconnection.impl.TelnetCLIConnection;
import org.apache.log4j.Logger;

public class Expect4GroovyScriptLauncher {
    Binding binding;
    CLIConnection connection;
    GroovyScriptEngine gse;
    static Logger logger = Logger.getLogger(Expect4GroovyScriptLauncher.class);

    public static void main(String[] args) throws IOException, ResourceException, ScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("protocol", "telnet");
        params.put("username", "lab");
        params.put("password", "lab123");
        params.put("enable-password", "lab123");
        params.put("address", "193.19.172.133");
        params.put("port", 11123);
        Expect4GroovyScriptLauncher launcher = new Expect4GroovyScriptLauncher();
        Map<String, Object> loginResult = launcher.open(new String[]{"conf/groovy/cisco/ios" + File.separator}, "cisco_login.groovy", params);
        if (loginResult.get("status").equals(2)) {
            logger.debug(loginResult);
        } else {
            LinkedHashMap<String, Object> cmdParams = new LinkedHashMap<String, Object>();
            cmdParams.put("evalScript", null);
            cmdParams.put("command", "ip route 10.200.1.0 255.255.255.0 192.0.2.1");
            Map<String, Object> result = launcher.sendCommand("cisco_sendConfigCommand.groovy", cmdParams);
            params.put("configMode", result.get("configMode"));
            cmdParams.put("command", "ip route 10.200.1.0 255.255.255.0 192.0.2.1");
            launcher.sendCommand("cisco_sendConfigCommand.groovy", cmdParams);
            launcher.close("cisco_logout.groovy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object launch(String[] roots, String scriptName, Map<String, Object> params) throws IOException, ResourceException, ScriptException {
        CLIConnection conn = this.createCliConnection(params);
        try {
            conn.connect(params);
            Binding binding = new Binding();
            Expect4Groovy.createBindings(conn, binding, true);
            binding.setProperty("params", params);
            GroovyScriptEngine gse = new GroovyScriptEngine(roots);
            Object object = gse.run(scriptName, binding);
            return object;
        }
        finally {
            conn.disconnect();
        }
    }

    public Map<String, Object> sendCommand(String scriptName, Map<String, Object> params) throws ResourceException, ScriptException {
        Map allParams = (Map)this.binding.getProperty("params");
        allParams.putAll(params);
        this.binding.setProperty("params", (Object)allParams);
        Map result = (Map)this.gse.run(scriptName, this.binding);
        return result;
    }

    public Map<String, Object> open(String[] roots, String scriptName, Map<String, Object> params) throws ResourceException, ScriptException {
        this.connection = this.createCliConnection(params);
        Map result = null;
        try {
            this.connection.connect(params);
            this.binding = new Binding();
            Expect4Groovy.createBindings(this.connection, this.binding, true);
            this.binding.setProperty("params", params);
            this.gse = new GroovyScriptEngine(roots);
            result = (Map)this.gse.run(scriptName, this.binding);
            if (result.get("status").equals("1")) {
                return result;
            }
            return result;
        }
        catch (IOException ioe) {
            logger.info((Object)ioe);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> close(String scriptName) throws ResourceException, ScriptException {
        try {
            Map result;
            Map map = result = (Map)this.gse.run(scriptName, this.binding);
            return map;
        }
        finally {
            try {
                this.connection.disconnect();
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }

    private CLIConnection createCliConnection(Map<String, Object> params) {
        Object conn = "telnet".equals(params.get("protocol")) ? new TelnetCLIConnection() : ("raw".equals(params.get("protocol")) ? new RawSocketCLIConnection() : ("echo".equals(params.get("protocol")) ? new EchoCLIConnection() : new SshCLIConnection()));
        return conn;
    }
}

