/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4java.cliconnection.impl;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import net.itransformers.expect4java.cliconnection.CLIConnection;

public class SshCLIConnection
implements CLIConnection {
    protected ChannelShell channel;
    protected Session session;
    protected InputStream inputStream;
    protected OutputStream outputStream;

    @Override
    public void connect(Map<String, Object> params) throws IOException {
        String username;
        String address = (String)params.get("address");
        if (address == null) {
            throw new RuntimeException("Missing parameter: address");
        }
        Integer port = 22;
        if (params.get("port") != null && !(params.get("port") instanceof Integer)) {
            throw new RuntimeException("invalid format of port parameter: " + params.get("port"));
        }
        if (params.get("port") != null) {
            port = (Integer)params.get("port");
        }
        if ((username = (String)params.get("username")) == null) {
            throw new RuntimeException("Missing parameter: username");
        }
        String password = (String)params.get("password");
        if (params.get("timeout") != null && !(params.get("timeout") instanceof Integer)) {
            throw new RuntimeException("invalid format of timeout parameter: " + params.get("timeout"));
        }
        Integer timeout = (Integer)params.get("timeout");
        JSch jsch = new JSch();
        if (params.get("config") != null && !(params.get("config") instanceof Hashtable)) {
            throw new RuntimeException("invalid config parameter");
        }
        Hashtable config = (Hashtable)params.get("config");
        UserInfo userInfo = null;
        if (params.get("userInfo") != null && params.get("userInfo") instanceof UserInfo) {
            userInfo = (UserInfo)params.get("userInfo");
        }
        try {
            this.session = jsch.getSession(username, address, port.intValue());
            if (password != null) {
                this.session.setPassword(password);
            }
            if (config != null) {
                this.session.setConfig(config);
            }
            if (userInfo != null) {
                this.session.setUserInfo(userInfo);
            }
            if (timeout != null) {
                this.session.connect(timeout.intValue());
            }
            this.channel = (ChannelShell)this.session.openChannel("shell");
            this.inputStream = this.channel.getInputStream();
            this.outputStream = this.channel.getOutputStream();
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream inputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            if (this.session != null) {
                this.session.disconnect();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

