/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4java.cliconnection.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import net.itransformers.expect4java.cliconnection.CLIConnection;
import org.apache.log4j.Logger;

public class RawSocketCLIConnection
implements CLIConnection {
    protected Socket socket;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected Logger logger = Logger.getLogger((String)RawSocketCLIConnection.class.getName());

    @Override
    public void connect(Map<String, Object> params) throws IOException {
        String address = (String)params.get("address");
        if (address == null) {
            throw new RuntimeException("Missing parameter: address");
        }
        if (!(params.get("port") instanceof Integer)) {
            throw new RuntimeException("invalid format of port in address parameter: " + address);
        }
        Integer port = (Integer)params.get("port");
        this.logger.info((Object)"Establishing connection ...");
        this.socket = new Socket(address, (int)port);
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.logger.info((Object)"Connection established");
    }

    @Override
    public InputStream inputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

