/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4java.cliconnection.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.itransformers.expect4java.cliconnection.CLIConnection;
import net.itransformers.expect4java.cliconnection.CLIStreamLogger;
import net.itransformers.expect4java.cliconnection.utils.OutputStreamCLILogger;
import net.itransformers.expect4java.cliconnection.utils.TeeInputStream;
import net.itransformers.expect4java.cliconnection.utils.TeeOutputStream;
import net.itransformers.expect4java.impl.Expect4jImpl;
import org.slf4j.LoggerFactory;

public class LoggableCLIConnection
implements CLIConnection {
    private TeeInputStream is;
    private TeeOutputStream os;
    private CLIConnection cliConnection;
    private final CLIStreamLogger inStreamLogger;
    private CLIStreamLogger outStreamLogger;
    private final char isLineTerminator;
    private final char osLineTerminator;
    private char lineTerminator;

    public LoggableCLIConnection(CLIConnection cliConnection) {
        this(cliConnection, message -> LoggerFactory.getLogger(Expect4jImpl.class).info(">>> " + message), message -> LoggerFactory.getLogger(Expect4jImpl.class).info("<<< " + message));
    }

    public LoggableCLIConnection(CLIConnection cliConnection, CLIStreamLogger inStreamLogger, CLIStreamLogger outStreamLogger) {
        this(cliConnection, inStreamLogger, outStreamLogger, '\n', '\n');
    }

    public LoggableCLIConnection(CLIConnection cliConnection, CLIStreamLogger inStreamLogger, CLIStreamLogger outStreamLogger, char isLineTerminator, char osLineTerminator) {
        this.cliConnection = cliConnection;
        this.inStreamLogger = inStreamLogger;
        this.outStreamLogger = outStreamLogger;
        this.isLineTerminator = isLineTerminator;
        this.osLineTerminator = osLineTerminator;
        if (inStreamLogger == null) {
            throw new IllegalArgumentException("Input logger cannot be null");
        }
        if (outStreamLogger == null) {
            throw new IllegalArgumentException("Output logger cannot be null");
        }
    }

    @Override
    public void connect(Map<String, Object> params) throws IOException {
        this.cliConnection.connect(params);
        InputStream origIs = this.cliConnection.inputStream();
        OutputStream origOs = this.cliConnection.outputStream();
        this.is = new TeeInputStream(origIs, new OutputStreamCLILogger(this.inStreamLogger, this.isLineTerminator));
        this.os = new TeeOutputStream(origOs, new OutputStreamCLILogger(this.outStreamLogger, this.osLineTerminator));
    }

    @Override
    public void disconnect() throws IOException {
        this.is.close();
        this.os.close();
        this.cliConnection.disconnect();
    }

    @Override
    public InputStream inputStream() {
        return this.is;
    }

    @Override
    public OutputStream outputStream() {
        return this.os;
    }
}

