/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.expect4java.cliconnection.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.itransformers.expect4java.cliconnection.CLIStreamLogger;

public class OutputStreamCLILogger
extends OutputStream {
    CLIStreamLogger logger;
    private char lineTerminator;
    protected ByteArrayOutputStream os;

    public OutputStreamCLILogger(CLIStreamLogger logger, char lineTerminator) {
        this.lineTerminator = lineTerminator;
        this.os = new ByteArrayOutputStream();
        this.logger = logger;
    }

    public OutputStreamCLILogger(CLIStreamLogger logger, int size, char lineTerminator) {
        this.os = new ByteArrayOutputStream(size);
        this.logger = logger;
        this.lineTerminator = lineTerminator;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b == this.lineTerminator) {
            this.doWrite(b);
            this.doFlush();
        } else {
            this.doWrite(b);
        }
    }

    protected void doFlush() {
        this.logger.log(this.os.toString());
        this.os.reset();
    }

    protected void doWrite(int b) throws IOException {
        if (b < 32) {
            switch (b) {
                case 13: {
                    this.os.write("[\\r]".getBytes());
                    break;
                }
                case 9: {
                    this.os.write("[\\t]".getBytes());
                    break;
                }
                case 10: {
                    this.os.write("[\\n]".getBytes());
                    break;
                }
                case 12: {
                    this.os.write("[\\f]".getBytes());
                    break;
                }
                case 7: {
                    this.os.write("[\\a]".getBytes());
                    break;
                }
                case 27: {
                    this.os.write("[\\e]".getBytes());
                    break;
                }
                case 29: {
                    this.os.write("[\\]]".getBytes());
                    break;
                }
                default: {
                    this.os.write(String.format("[\\x%02X]", b).getBytes());
                    break;
                }
            }
        } else {
            this.os.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.doFlush();
            this.os = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.doFlush();
    }
}

