/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit.transform;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.itransformers.snmp2xml4j.snmptoolkit.transform.Log4jEmitter;
import net.sf.saxon.TransformerFactoryImpl;

public class StylesheetCache {
    private static Map cache = new HashMap();

    public static synchronized void flushAll() {
        cache.clear();
    }

    public static synchronized void flush(String xsltFileName) {
        cache.remove(xsltFileName);
    }

    public static synchronized Transformer newTransformer(File xsltFile) throws TransformerConfigurationException {
        long xslLastModified = xsltFile.lastModified();
        String xsltFileName = xsltFile.getName();
        MapEntry entry = (MapEntry)cache.get(xsltFileName);
        if (entry != null && xslLastModified > entry.lastModified) {
            entry = null;
        }
        if (entry == null) {
            StreamSource xslSource = new StreamSource(xsltFile);
            TransformerFactory transFact = TransformerFactory.newInstance();
            ((TransformerFactoryImpl)transFact).getConfiguration().setMessageEmitterClass(Log4jEmitter.class.getName());
            Templates templates = transFact.newTemplates(xslSource);
            entry = new MapEntry(xslLastModified, templates);
            cache.put(xsltFileName, entry);
        }
        return entry.templates.newTransformer();
    }

    private StylesheetCache() {
    }

    static class MapEntry {
        long lastModified;
        Templates templates;

        MapEntry(long lastModified, Templates templates) {
            this.lastModified = lastModified;
            this.templates = templates;
        }
    }
}

