/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.UdpTransportMapping;
import org.snmp4j.util.WorkerTask;

public class LogBasedTransportMapping
extends UdpTransportMapping
implements TransportMapping {
    public static Pattern p = Pattern.compile("^(.*DefaultUdpTransportMapping.*Received message from /(.*) with length.*: )(.*)$");
    static Logger logger = Logger.getLogger(DefaultUdpTransportMapping.class);
    protected WorkerTask listener;
    protected ListenThread listenerThread;
    private int receiveBufferSize = 0;
    private BufferedReader reader;

    public LogBasedTransportMapping(BufferedReader reader, TransportIpAddress transportIpAddress) throws IOException {
        super(new UdpAddress(InetAddress.getLocalHost(), 0));
        this.reader = reader;
    }

    public void sendMessage(Address targetAddress, byte[] message) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message to " + this.udpAddress + " with length " + message.length + ": " + new OctetString(message).toHexString());
        }
    }

    public void close() throws IOException {
        boolean interrupted = false;
        WorkerTask l = this.listener;
        if (l != null) {
            l.terminate();
            l.interrupt();
            try {
                l.join();
            }
            catch (InterruptedException ex) {
                interrupted = true;
                logger.warn(ex);
            }
        }
        this.listener = null;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void listen() throws IOException {
        if (this.listener != null) {
            throw new SocketException("Port already listening");
        }
        this.listenerThread = new ListenThread();
        this.listener = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultUDPTransportMapping_" + this.getAddress(), this.listenerThread, true);
        this.listener.run();
    }

    public void setPriority(int newPriority) {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setPriority(newPriority);
        }
    }

    public int getPriority() {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getName();
        }
        return null;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isListening() {
        return this.listener != null;
    }

    class ListenThread
    implements WorkerTask {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() {
            this.buf = new byte[LogBasedTransportMapping.this.getMaxInboundMessageSize()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ByteBuffer bis;
            logger.debug("UDP receive buffer size for socket " + LogBasedTransportMapping.this.getAddress() + " is set to: ...");
            String msg = null;
            String addr = null;
            try {
                String s;
                while ((s = LogBasedTransportMapping.this.reader.readLine()) != null) {
                    Matcher m = p.matcher(s);
                    if (!m.find()) continue;
                    addr = m.group(2);
                    msg = m.group(3);
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (msg == null) {
                return;
            }
            OctetString message = OctetString.fromHexString(msg, ':');
            byte[] packet = message.getValue();
            logger.debug("Received message from " + addr + " with length " + packet.length + ": " + new OctetString(packet, 0, packet.length).toHexString());
            if (LogBasedTransportMapping.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[packet.length];
                System.arraycopy(packet, 0, bytes, 0, bytes.length);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(packet);
            }
            LogBasedTransportMapping.this.fireProcessMessage(new UdpAddress(addr), bis);
            LogBasedTransportMapping logBasedTransportMapping = LogBasedTransportMapping.this;
            synchronized (logBasedTransportMapping) {
                LogBasedTransportMapping.this.listener = null;
                this.stop = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("Worker task stopped:" + this.getClass().getName());
                }
            }
        }

        public void close() {
            this.stop = true;
        }

        public void terminate() {
            this.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Terminated worker task: " + this.getClass().getName());
            }
        }

        public void join() throws InterruptedException {
            if (logger.isDebugEnabled()) {
                logger.debug("Joining worker task: " + this.getClass().getName());
            }
        }

        public void interrupt() {
            if (logger.isDebugEnabled()) {
                logger.debug("Interrupting worker task: " + this.getClass().getName());
            }
            this.close();
        }
    }
}

