/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.AbstractTransportMapping;

public class LogBasedTransportMapping1
extends AbstractTransportMapping
implements TransportMapping {
    public static Pattern p = Pattern.compile("^(.*DefaultUdpTransportMapping.*Received message from /(.*) with length.*: )(.*)$");
    static Logger logger = Logger.getLogger(LogBasedTransportMapping1.class);
    protected TransportIpAddress udpAddress;
    private boolean isListening = false;
    private Thread listeningThread;
    private BufferedReader reader;

    public LogBasedTransportMapping1(BufferedReader reader, TransportIpAddress transportIpAddress) {
        this.udpAddress = transportIpAddress;
        this.reader = reader;
    }

    public Class getSupportedAddressClass() {
        return UdpAddress.class;
    }

    public Address getListenAddress() {
        return this.udpAddress;
    }

    public void close() throws IOException {
        this.isListening = false;
    }

    public void listen() throws IOException {
        this.isListening = true;
        logger.debug("UDP receive buffer size for socket " + this.udpAddress + " is set to: ...");
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void sendMessage(Address address, byte[] message) throws IOException {
        logger.debug("Sending message to " + this.udpAddress + " with length " + message.length + ": " + new OctetString(message).toHexString());
        this.listeningThread = this.createTrehad();
        this.listeningThread.run();
    }

    private Thread createTrehad() {
        return new Thread(){

            public void run() {
                LogBasedTransportMapping1.this.isListening = true;
                String msg = null;
                String addr = null;
                try {
                    String s;
                    while ((s = LogBasedTransportMapping1.this.reader.readLine()) != null) {
                        Matcher m = p.matcher(s);
                        if (!m.find()) continue;
                        addr = m.group(2);
                        msg = m.group(3);
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                if (msg == null) {
                    return;
                }
                OctetString message = OctetString.fromHexString(msg, ':');
                byte[] packet = message.getValue();
                logger.debug("Received message from " + addr + " with length " + packet.length + ": " + new OctetString(packet, 0, packet.length).toHexString());
                LogBasedTransportMapping1.this.fireProcessMessage(new UdpAddress(addr), ByteBuffer.wrap(message.getValue()));
            }
        };
    }
}

