/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class ValueConstraint
implements Constraint {
    private FileLocation location;
    private MibValue value;

    public ValueConstraint(FileLocation location, MibValue value) {
        this.location = location;
        this.value = value;
    }

    public void initialize(MibType type, MibLoaderLog log) throws MibException {
        this.value = this.value.initialize(log, type);
        if (this.location != null && !this.isCompatible(type)) {
            String message = "Value constraint not compatible with this type";
            log.addWarning(this.location, message);
        }
        this.location = null;
    }

    public boolean isCompatible(MibType type) {
        return type == null || this.value == null || type.isCompatible(this.value);
    }

    public boolean isCompatible(MibValue value) {
        String str1 = this.value.toString();
        String str2 = value.toString();
        if (this.value instanceof NumberValue && value instanceof NumberValue) {
            return str1.equals(str2);
        }
        if (this.value instanceof StringValue && value instanceof StringValue) {
            return str1.equals(str2);
        }
        return false;
    }

    public MibValue getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

