/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.TransportMapping;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class MultiThreadedMessageDispatcher
implements MessageDispatcher {
    private MessageDispatcher dispatcher;
    private WorkerPool threadPool;

    public MultiThreadedMessageDispatcher(WorkerPool workerPool, MessageDispatcher decoratedDispatcher) {
        this.threadPool = workerPool;
        this.dispatcher = decoratedDispatcher;
    }

    public int getNextRequestID() {
        return this.dispatcher.getNextRequestID();
    }

    public void addMessageProcessingModel(MessageProcessingModel model) {
        this.dispatcher.addMessageProcessingModel(model);
    }

    public void removeMessageProcessingModel(MessageProcessingModel model) {
        this.dispatcher.removeMessageProcessingModel(model);
    }

    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        return this.dispatcher.getMessageProcessingModel(messageProcessingModel);
    }

    public void addTransportMapping(TransportMapping transport) {
        this.dispatcher.addTransportMapping(transport);
    }

    public TransportMapping removeTransportMapping(TransportMapping transport) {
        return this.dispatcher.removeTransportMapping(transport);
    }

    public Collection getTransportMappings() {
        return this.dispatcher.getTransportMappings();
    }

    public void addCommandResponder(CommandResponder listener) {
        this.dispatcher.addCommandResponder(listener);
    }

    public void removeCommandResponder(CommandResponder listener) {
        this.dispatcher.removeCommandResponder(listener);
    }

    public PduHandle sendPdu(Address transportAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse) throws MessageException {
        return this.dispatcher.sendPdu(transportAddress, messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse);
    }

    public PduHandle sendPdu(TransportMapping transportMapping, Address transportAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, transportAddress, messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse);
    }

    public PduHandle sendPdu(TransportMapping transportMapping, Address transportAddress, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse, PduHandleCallback callback) throws MessageException {
        return this.dispatcher.sendPdu(transportMapping, transportAddress, messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse, callback);
    }

    public int returnResponsePdu(int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference stateReference, StatusInformation statusInformation) throws MessageException {
        return this.dispatcher.returnResponsePdu(messageProcessingModel, securityModel, securityName, securityLevel, pdu, maxSizeResponseScopedPDU, stateReference, statusInformation);
    }

    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, BERInputStream wholeMessage) {
        MessageTask task = new MessageTask(sourceTransport, incomingAddress, wholeMessage);
        this.threadPool.execute(task);
    }

    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, ByteBuffer wholeMessage) {
        this.processMessage(sourceTransport, incomingAddress, new BERInputStream(wholeMessage.duplicate()));
    }

    public void releaseStateReference(int messageProcessingModel, PduHandle pduHandle) {
        this.dispatcher.releaseStateReference(messageProcessingModel, pduHandle);
    }

    public TransportMapping getTransport(Address destAddress) {
        return this.dispatcher.getTransport(destAddress);
    }

    class MessageTask
    implements WorkerTask {
        private TransportMapping sourceTransport;
        private Address incomingAddress;
        private BERInputStream wholeMessage;

        public MessageTask(TransportMapping sourceTransport, Address incomingAddress, BERInputStream wholeMessage) {
            this.sourceTransport = sourceTransport;
            this.incomingAddress = incomingAddress;
            this.wholeMessage = wholeMessage;
        }

        public void run() {
            MultiThreadedMessageDispatcher.this.dispatcher.processMessage(this.sourceTransport, this.incomingAddress, this.wholeMessage);
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }
}

