/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.IOException;
import java.util.Vector;
import net.itransformers.snmp2xml4j.snmptoolkit.Walk;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.MessageDispatcherAbstractFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.TransportMappingAbstractFactory;
import org.apache.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Get {
    static Logger logger = Logger.getLogger(Walk.class);
    String oid;
    String community;
    private UdpAddress localAddress;
    private TransportMappingAbstractFactory transportFactory;
    private MessageDispatcherAbstractFactory messageDispatcherFactory;
    CommunityTarget target = new CommunityTarget();

    public Get(String oid, CommunityTarget target, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherAbstractFactory) {
        this.oid = oid;
        this.target = target;
        this.transportFactory = transportFactory;
        this.messageDispatcherFactory = messageDispatcherAbstractFactory;
        this.transportFactory = transportFactory;
        this.localAddress = new UdpAddress("0.0.0.0/0");
    }

    public Get(String oid, String address, int version, int retries, long timeout, String community, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherAbstractFactory) throws IOException {
        this.oid = oid;
        this.target = new CommunityTarget();
        this.target.setAddress((Address)new UdpAddress(address));
        this.target.setRetries(retries);
        this.target.setTimeout(timeout);
        this.target.setVersion(version);
        this.target.setMaxSizeRequestPDU(65535);
        this.target.setCommunity(new OctetString(community));
        this.community = community;
        this.transportFactory = transportFactory;
        this.messageDispatcherFactory = messageDispatcherAbstractFactory;
        this.localAddress = new UdpAddress("0.0.0.0/0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSNMPValue() throws IOException {
        String result = "";
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        VariableBinding vb = new VariableBinding(new OID(this.oid));
        Vector<VariableBinding> vbs = new Vector<VariableBinding>();
        vbs.add(vb);
        TransportMapping transport = this.transportFactory.createTransportMapping((TransportIpAddress)this.localAddress);
        MessageDispatcher dispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        Snmp snmp = new Snmp(dispatcher, transport);
        ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(new OctetString(MPv3.createLocalEngineID()).getValue());
        snmp.listen();
        try {
            PDU request = new PDU();
            request.setType(-96);
            for (int i = 0; i < vbs.size(); ++i) {
                request.add((VariableBinding)vbs.get(i));
            }
            long startTime = System.currentTimeMillis();
            ResponseEvent responseEvent = snmp.send(request, (Target)this.target, transport);
            PDU response = null;
            if (responseEvent != null) {
                response = responseEvent.getResponse();
                logger.debug((Object)("Received response after " + (System.currentTimeMillis() - startTime) + " millis"));
            }
            if (response == null) {
                logger.debug((Object)"SNMP response is null.");
                String string = null;
                return string;
            }
            for (int i = 0; i < response.size(); ++i) {
                VariableBinding vb1 = response.get(i);
                result = vb1.getVariable().toString();
            }
            String string = result;
            return string;
        }
        finally {
            logger.debug((Object)("Error " + snmp.toString()));
            snmp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSNMPGetNextValue() throws IOException {
        String result = "";
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        VariableBinding vb = new VariableBinding(new OID(this.oid));
        Vector<VariableBinding> vbs = new Vector<VariableBinding>();
        vbs.add(vb);
        TransportMapping transport = this.transportFactory.createTransportMapping((TransportIpAddress)this.localAddress);
        MessageDispatcher dispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        Snmp snmp = new Snmp(dispatcher, transport);
        ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(new OctetString(MPv3.createLocalEngineID()).getValue());
        snmp.listen();
        try {
            PDU request = new PDU();
            request.setType(-95);
            for (int i = 0; i < vbs.size(); ++i) {
                request.add((VariableBinding)vbs.get(i));
            }
            long startTime = System.currentTimeMillis();
            ResponseEvent responseEvent = snmp.send(request, (Target)this.target, transport);
            PDU response = null;
            if (responseEvent != null) {
                response = responseEvent.getResponse();
                logger.debug((Object)("Received response after " + (System.currentTimeMillis() - startTime) + " millis"));
            }
            if (response == null) {
                logger.debug((Object)"SNMP response is null.");
                String string = null;
                return string;
            }
            for (int i = 0; i < response.size(); ++i) {
                VariableBinding vb1 = response.get(i);
                result = vb1.getVariable().toString();
            }
            String string = result;
            return string;
        }
        finally {
            logger.debug((Object)("Error " + snmp.toString()));
            snmp.close();
        }
    }

    public static void main(String[] args) throws IOException {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        VariableBinding vb = new VariableBinding(new OID(".1.3.6.1.4.1.9.10.86.1.1.1.1.5.1.2.16.32.1.4.112.31.11.10.189.0.0.0.0.0.0.0.0.96"));
        Vector<VariableBinding> vbs = new Vector<VariableBinding>();
        vbs.add(vb);
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp((TransportMapping)transport);
        ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(new OctetString(MPv3.createLocalEngineID()).getValue());
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("ciscoIp"));
        target.setVersion(1);
        target.setAddress((Address)new UdpAddress("192.168.107.33/11161"));
        target.setRetries(1);
        target.setTimeout(1000L);
        target.setMaxSizeRequestPDU(65535);
        snmp.listen();
        PDU request = new PDU();
        request.setType(-96);
        for (int i = 0; i < vbs.size(); ++i) {
            request.add((VariableBinding)vbs.get(i));
        }
        long startTime = System.currentTimeMillis();
        ResponseEvent responseEvent = snmp.send(request, (Target)target);
        PDU response = null;
        if (responseEvent != null) {
            response = responseEvent.getResponse();
            System.out.println("Received response after " + (System.currentTimeMillis() - startTime) + " millis");
        }
        System.out.println("Response received with requestID=" + response.getRequestID() + ", errorIndex=" + response.getErrorIndex() + ", " + "errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")");
        for (int i = 0; i < response.size(); ++i) {
            VariableBinding vb1 = response.get(i);
            System.out.println(vb1.toString());
        }
        snmp.close();
    }
}

