/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.util.HashMap;
import java.util.Map;
import net.itransformers.snmp2xml4j.snmptoolkit.CmdOptions;
import net.itransformers.snmp2xml4j.snmptoolkit.OsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmdParser {
    CmdParser() {
    }

    public static Map<CmdOptions, String> parseCmd(String[] args) throws Exception {
        HashMap<CmdOptions, String> result = new HashMap<CmdOptions, String>();
        block0: for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            for (CmdOptions cmdOpt : CmdOptions.values()) {
                if (!opt.equals("-" + cmdOpt.getName())) continue;
                if (cmdOpt.getValueSize() == 0) continue block0;
                if (cmdOpt.getValueSize() == 1) {
                    if (i + 1 < args.length) {
                        result.put(cmdOpt, args[i + 1]);
                        continue;
                    }
                    throw new Exception("missing value for \"-" + cmdOpt.getName() + "\" option");
                }
                throw new RuntimeException("Unsupported value size");
            }
        }
        return result;
    }

    public static void printWalkUsage(String os) {
        if ("Windows".equalsIgnoreCase(os)) {
            System.out.println("Usage: snmpwalk.bat -md <mibs_dir> -v <version> -a <address> -p <port> -pr <protocol> -c <community> -u <security_name> -aa <auth-level> -A <auth_passphrare> -ap <auth_protocol> -pp <priv_protocol> -Y <priv_passphrase> -t <timeout> -r <retries> -m <max_repetitions> [-f <output_file>] -o <oid_names>");
            System.out.println("Example v1/v2c: snmpwalk.bat -md snmptoolkit/mibs -v 2c -a 195.218.195.228 -p 161 -pr udp -c public -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, sysName\"");
            System.out.println("Example v3c: snmpwalk.bat  -md snmptoolkit/mibs -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, sysName\"");
        } else {
            System.out.println("Usage: snmpwalk.sh -md <mibs_dir> -v <version> -a <address> -p <port> -pr <protocol> -c <community> -u <security_name> -aa <auth-level> -A <auth_passphrare> -ap <auth_protocol> -pp <priv_protocol> -Y <priv_passphrase> -t <timeout> -r <retries> -m <max_repetitions> [-f <output_file>] -o <oid_names>");
            System.out.println("Example v1/v2c: snmpwalk.sh -md snmptoolkit/mibs -v 2c -a 195.218.195.228 -p 161 -pr udp -c public -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, sysName\"");
            System.out.println("Example v3c: snmpwalk.sh -md snmptoolkit/mibs -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, sysName\"");
        }
    }

    private static void printGetUsage(String os) {
        if ("Windows".equalsIgnoreCase(os)) {
            System.out.println("snmpget.bat -md <mibs_dir> -v <version> -a <address> -p <port> -pr <protocol> -c <community> -u <security_name> -aa <auth-level> -A <auth_passphrare> -ap <auth_protocol> -pp <priv_protocol> -Y <priv_passphrase> -t <timeout> -r <retries> -m <max_repetitions> [-f <output_file>] -o <oid_names>");
            System.out.println("Example v1/v2c: snmpget.bat -md snmptoolkit/mibs -v 2c -a 195.218.195.228 -p 161 -pr udp -c public -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, 1.3.6.1.2.1.1.1\"");
            System.out.println("Example v3c - Auth-noPriv: snmpget.bat -md snmptoolkit/mibs -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, 1.3.6.1.2.1.1.5\"");
            System.out.println("Example v3c - Auth-noPriv: snmpget.bat -md snmptoolkit/mibs -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, 1.3.6.1.2.1.1.5\"");
        } else {
            System.out.println("snmpget.sh -md <mibs_dir> -v <version> -a <address> -p <port> -pr <protocol> -c <community> -u <security_name> -aa <auth-level> -A <auth_passphrare> -ap <auth_protocol> -pp <priv_protocol> -Y <priv_passphrase> -t <timeout> -r <retries> -m <max_repetitions> [-f <output_file>] -o <oid_names>");
            System.out.println("Example v1/v2c: snmpget.sh -md snmptoolkit/mibs -v 2c -a 195.218.195.228 -p 161 -pr udp -c public -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, 1.3.6.1.2.1.1.1\"");
            System.out.println("Example v3c - Auth-noPriv: snmpget.sh  -md snmptoolkit/mibs -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, 1.3.6.1.2.1.1.5\"");
            System.out.println("Example v3c - Auth-noPriv: snmpget.s -md snmptoolkit/mibs -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, 1.3.6.1.2.1.1.5\"");
        }
    }

    public static void printUsage(String operation) {
        String os = OsUtils.isWindows() ? "Windows" : "Unix";
        if ("get".equalsIgnoreCase(operation)) {
            CmdParser.printGetUsage(os);
        } else if ("walk".equalsIgnoreCase(operation)) {
            CmdParser.printWalkUsage(os);
        } else if ("set".equalsIgnoreCase(operation)) {
            CmdParser.printSetUsage(os);
        }
    }

    private static void printSetUsage(String os) {
    }
}

