/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import net.itransformers.snmp2xml4j.snmptoolkit.CmdOptions;
import net.itransformers.snmp2xml4j.snmptoolkit.CmdParser;
import net.itransformers.snmp2xml4j.snmptoolkit.MibLoaderHolder;
import net.itransformers.snmp2xml4j.snmptoolkit.Node;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpManager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpTcpV1Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpTcpV2Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpTcpV3Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpUdpV1Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpUdpV2Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpUdpV3Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpXmlPrinter;
import net.percederberg.mibble.MibLoaderException;
import org.snmp4j.PDU;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Launcher {
    Launcher() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(String[] args) throws IOException, MibLoaderException {
        String community;
        String protocol;
        Map<CmdOptions, String> opts;
        SnmpManager snmpManager = null;
        try {
            opts = CmdParser.parseCmd(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            CmdParser.printUsage("GET");
            return;
        }
        String operation = opts.get((Object)CmdOptions.OPERATION);
        if (operation == null) {
            System.out.println("Missing option \"-" + CmdOptions.OPERATION.getName() + " Possible options are get,set,walk " + "\"");
            CmdParser.printUsage("GET");
            return;
        }
        String mibDir = opts.get((Object)CmdOptions.MIBS_DIR);
        if (mibDir == null) {
            System.out.println("Missing option \"-" + CmdOptions.MIBS_DIR.getName() + "\"");
            CmdParser.printUsage(operation);
            return;
        }
        MibLoaderHolder mibLoaderHolder = new MibLoaderHolder(new File(mibDir), false);
        String address = opts.get((Object)CmdOptions.ADDRESS);
        if (address == null) {
            System.out.println("Missing option \"-" + CmdOptions.ADDRESS.getName() + "\"");
            CmdParser.printWalkUsage(operation);
            return;
        }
        String port = opts.get((Object)CmdOptions.PORT);
        int portInt = 161;
        if (port != null) {
            try {
                portInt = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid parameter value for \"-" + (Object)((Object)CmdOptions.PORT) + "\", int value is required");
                CmdParser.printUsage(operation);
            }
        }
        if ((protocol = opts.get((Object)CmdOptions.PROTOCOL)) == null) {
            protocol = "udp";
        }
        String timeout = opts.get((Object)CmdOptions.TIMEOUT);
        int timeoutInt = 1000;
        if (timeout != null) {
            try {
                timeoutInt = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid parameter value for \"-" + (Object)((Object)CmdOptions.TIMEOUT) + "\", int value is required");
                CmdParser.printUsage(operation);
            }
        } else {
            System.out.println("Using default timeout: 1000");
        }
        String retries = opts.get((Object)CmdOptions.RETRIES);
        int retriesInt = 1;
        if (retries != null) {
            try {
                retriesInt = Integer.parseInt(retries);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid parameter value for \"-" + (Object)((Object)CmdOptions.RETRIES) + "\", int value is required");
                CmdParser.printWalkUsage(operation);
            }
        } else {
            System.out.println("Using default retries: 1");
        }
        String version = opts.get((Object)CmdOptions.VERSION);
        if (version == null) {
            System.out.println("Missing option \"-" + CmdOptions.VERSION.getName() + "\"");
            CmdParser.printWalkUsage(operation);
            return;
        }
        if (version.equalsIgnoreCase("1")) {
            community = opts.get((Object)CmdOptions.COMMUNITY);
            if (community == null) {
                System.out.println("Missing option \"-" + CmdOptions.COMMUNITY.getName() + "\"");
                CmdParser.printWalkUsage(operation);
                return;
            }
            snmpManager = "udp".equals(protocol) ? new SnmpUdpV1Manager(mibLoaderHolder.getLoader(), address, community, retriesInt, timeoutInt, 65535, portInt) : new SnmpTcpV1Manager(mibLoaderHolder.getLoader(), address, community, retriesInt, timeoutInt, 65535, portInt);
        } else if (version.equalsIgnoreCase("2") || version.equalsIgnoreCase("2c")) {
            community = opts.get((Object)CmdOptions.COMMUNITY);
            if (community == null) {
                System.out.println("Missing option \"-" + CmdOptions.COMMUNITY.getName() + "\"");
                CmdParser.printUsage(operation);
                return;
            }
            snmpManager = "udp".equals(protocol) ? new SnmpUdpV2Manager(mibLoaderHolder.getLoader(), address, community, retriesInt, timeoutInt, 65535, portInt) : new SnmpTcpV2Manager(mibLoaderHolder.getLoader(), address, community, retriesInt, timeoutInt, 65535, portInt);
        } else if (version.equalsIgnoreCase("3")) {
            int authLevelInt;
            String authLevel = opts.get((Object)CmdOptions.AUTH_LEVEL);
            String securityName = opts.get((Object)CmdOptions.SECURITY_NAME);
            String authPassshare = opts.get((Object)CmdOptions.AUTH_PASSPHRASE);
            String authProtocol = opts.get((Object)CmdOptions.AUTH_PROTOCOL);
            String privacyPassshare = opts.get((Object)CmdOptions.PRIV_PASSPHRASE);
            String privacyProtocol = opts.get((Object)CmdOptions.PRIV_PROTOCOL);
            if (securityName == null) {
                System.out.println("Missing option \"-" + CmdOptions.SECURITY_NAME.getName() + "\"");
                CmdParser.printUsage(operation);
                return;
            }
            if (authLevel == null) {
                System.out.println("Missing option \"-" + CmdOptions.AUTH_LEVEL.getName() + "\"");
                CmdParser.printUsage(operation);
                return;
            }
            if (authLevel.equalsIgnoreCase("AUTH_NOPRIV")) {
                authLevelInt = 2;
                if (authPassshare == null) {
                    System.out.println("Missing option \"-" + CmdOptions.AUTH_PASSPHRASE.getName() + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
                if (authProtocol == null) {
                    System.out.println("Missing option \"-" + CmdOptions.AUTH_PROTOCOL.getName() + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
            } else if (authLevel.equalsIgnoreCase("AUTH_PRIV")) {
                authLevelInt = 3;
                if (authPassshare == null) {
                    System.out.println("Missing option \"-" + CmdOptions.AUTH_PASSPHRASE.getName() + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
                if (authProtocol == null) {
                    System.out.println("Missing option \"-" + CmdOptions.AUTH_PROTOCOL.getName() + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
                if (privacyProtocol == null) {
                    System.out.println("Missing option \"-" + CmdOptions.PRIV_PROTOCOL.getName() + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
                if (privacyPassshare == null) {
                    System.out.println("Missing option \"-" + CmdOptions.PRIV_PASSPHRASE.getName() + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
            } else {
                if (!authLevel.equalsIgnoreCase("NOAUTH_NOPRIV")) {
                    System.out.println("Unrecognized \"-" + (Object)((Object)CmdOptions.AUTH_LEVEL) + "\"");
                    CmdParser.printUsage(operation);
                    return;
                }
                authLevelInt = 1;
            }
            snmpManager = "udp".equals(protocol) ? new SnmpUdpV3Manager(mibLoaderHolder.getLoader(), address, authLevelInt, securityName, authPassshare, authProtocol, privacyProtocol, privacyPassshare, retriesInt, timeoutInt, 65535, portInt) : new SnmpTcpV3Manager(mibLoaderHolder.getLoader(), address, authLevelInt, securityName, authPassshare, authProtocol, privacyProtocol, privacyPassshare, retriesInt, timeoutInt, 65535, portInt);
        }
        if (snmpManager == null) {
            System.out.println("Unable to initialize SNMP manager");
            return;
        }
        snmpManager.init();
        ArrayList<String> includesList = new ArrayList<String>();
        String oids = opts.get((Object)CmdOptions.OIDS);
        if (oids == null) {
            System.out.println("Missing option \"-" + CmdOptions.OIDS.getName());
            CmdParser.printWalkUsage(operation);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(oids, " ,;");
        while (tokenizer.hasMoreTokens()) {
            includesList.add(tokenizer.nextToken());
        }
        if (operation.equalsIgnoreCase("walk")) {
            Node root = snmpManager.walk(includesList.toArray(new String[includesList.size()]));
            SnmpXmlPrinter snmpXmlPrinter = new SnmpXmlPrinter(mibLoaderHolder.getLoader(), root);
            String xml = snmpXmlPrinter.printTreeAsXML();
            Launcher.outputXml(opts, xml);
            return;
        }
        if (!operation.equalsIgnoreCase("get")) return;
        ResponseEvent responseEvent = snmpManager.get(includesList);
        if (responseEvent == null) {
            System.out.println("PDU response event is null");
            return;
        }
        PDU response = responseEvent.getResponse();
        if (response == null) return;
        int i = 0;
        while (i < response.size()) {
            VariableBinding vb1 = response.get(i);
            System.out.println(vb1.getVariable().toString());
            ++i;
        }
    }

    private static void outputXml(Map<CmdOptions, String> opts, String finalXml) throws FileNotFoundException {
        String outputFile = opts.get((Object)CmdOptions.OUTPUT_FILE);
        if (outputFile == null) {
            System.out.println(finalXml);
        } else {
            PrintWriter writer = new PrintWriter(outputFile);
            writer.print(finalXml);
            writer.flush();
            writer.close();
        }
    }
}

