/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.itransformers.snmp2xml4j.snmptoolkit.MibLoaderHolder;
import net.itransformers.snmp2xml4j.snmptoolkit.Node;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpUdpV2Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpUdpV3Manager;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpXmlPrinter;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.DefaultMessageDispatcherFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.MessageDispatcherAbstractFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.TransportMappingAbstractFactory;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.BooleanType;
import net.percederberg.mibble.type.ChoiceType;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.NullType;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.type.RealType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.TypeReference;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnmpManager {
    protected Snmp snmp = null;
    static Logger logger = Logger.getLogger(SnmpManager.class);
    protected int retries;
    protected int timeout;
    protected int maxSizeRequestPDU = 65535;
    protected int destinationPort = 161;
    private MessageDispatcherAbstractFactory messageDispatcherFactory;
    private TransportMappingAbstractFactory transportMappingAbstractFactory;
    private TransportIpAddress transportLocalIpAddress;
    protected MibLoader loader;
    protected PDUFactory pduFactory;

    public SnmpManager(MibLoader loader, int retries, int timeout, int maxSizeRequestPDU, int destinationPort, TransportMappingAbstractFactory transportMappingAbstractFactory, TransportIpAddress transportLocalIpAddress) {
        this.retries = retries;
        this.timeout = timeout;
        this.maxSizeRequestPDU = maxSizeRequestPDU;
        this.destinationPort = destinationPort;
        this.messageDispatcherFactory = new DefaultMessageDispatcherFactory();
        this.transportMappingAbstractFactory = transportMappingAbstractFactory;
        this.pduFactory = new DefaultPDUFactory();
        this.transportLocalIpAddress = transportLocalIpAddress;
        this.loader = loader;
    }

    protected abstract void doInit() throws IOException;

    public void init() throws IOException {
        TransportMapping transportMapping = this.transportMappingAbstractFactory.createTransportMapping(this.transportLocalIpAddress);
        MessageDispatcher messageDispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        this.snmp = new Snmp(messageDispatcher, transportMapping);
        this.doInit();
        transportMapping.listen();
    }

    public ResponseEvent set(OID[] oids, int value) {
        PDU pdu = this.createPDU();
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid, (Variable)new Integer32(value)));
        }
        pdu.setType(-93);
        ResponseEvent event = null;
        try {
            event = this.snmp.send(pdu, this.getTarget(), null);
        }
        catch (IOException ioe) {
            System.out.println("Error SNMP SET");
        }
        if (event != null) {
            return event;
        }
        throw new RuntimeException("SET timed out");
    }

    public ResponseEvent get(ArrayList<String> oidStrings) throws IOException {
        OID[] oidOids = new OID[oidStrings.size()];
        int i = 0;
        for (String oid : oidStrings) {
            MibValueSymbol symbol = this.findSymbolFromMibs(oid);
            if (symbol == null) {
                oidOids[i] = new OID(oid);
            } else {
                String oidd = symbol.getValue().toString();
                oidOids[i] = new OID(oidd);
            }
            ++i;
        }
        return this.getNext(oidOids);
    }

    public ResponseEvent get(OID[] oids) throws IOException {
        PDU pdu = this.pduFactory.createPDU(this.getTarget());
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid));
        }
        pdu.setType(-96);
        ResponseEvent response = this.snmp.send(pdu, this.getTarget());
        if (response != null) {
            PDU responsePDU = response.getResponse();
            if (responsePDU != null && responsePDU.getErrorStatus() == 0) {
                return response;
            }
            logger.log(Priority.INFO, (Object)("GET reposne from " + this.getTarget().getAddress() + " was null!"));
            return null;
        }
        logger.log(Priority.INFO, (Object)("GET from " + this.getTarget().getAddress() + " has timed out!"));
        return null;
    }

    public ResponseEvent getNext(OID[] oids) throws IOException {
        PDU pdu = this.pduFactory.createPDU(this.getTarget());
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid));
        }
        pdu.setType(-95);
        ResponseEvent response = this.snmp.send(pdu, this.getTarget());
        if (response != null) {
            PDU responsePDU = response.getResponse();
            if (responsePDU != null && responsePDU.getErrorStatus() == 0) {
                return response;
            }
            logger.log(Priority.INFO, (Object)("GET reposne from " + this.getTarget().getAddress() + " was null!"));
            return null;
        }
        logger.log(Priority.INFO, (Object)("GET from " + this.getTarget().getAddress() + " has timed out!"));
        return null;
    }

    protected abstract Target getTarget();

    protected abstract PDU createPDU();

    public Node walk(String[] includes) throws IOException {
        ObjectIdentifierValue oid = this.loader.getRootOid();
        HashSet<String> includesSet = new HashSet<String>(Arrays.asList(includes));
        Node rootNode = new Node(oid, null);
        this.fillTreeFromMib(rootNode);
        this.fillDoWalk(rootNode, includesSet);
        this.fillTreeFromSNMP(rootNode);
        return rootNode;
    }

    private void fillTreeFromMib(Node node) {
        ObjectIdentifierValue[] children;
        ObjectIdentifierValue oid = node.getObjectIdentifierValue();
        for (ObjectIdentifierValue child : children = oid.getAllChildren()) {
            if (child == null) continue;
            Node childNode = new Node(child, node);
            node.addChild(childNode);
            this.fillTreeFromMib(childNode);
        }
    }

    protected void fillTreeFromSNMP(Node root) throws IOException {
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        try {
            TableUtils tutils = new TableUtils((Session)this.snmp, this.pduFactory);
            this.fillTreeFromSNMP(root, tutils);
        }
        finally {
            this.snmp.close();
        }
    }

    private void fillDoWalk(Node node, Set includes) {
        if (includes.contains(node.getObjectIdentifierValue().getName())) {
            for (Node currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
                currentNode.setDoWalk(true);
            }
            this.fillDoWalkChildren(node);
        }
        for (Node child : node.getChildren()) {
            this.fillDoWalk(child, includes);
        }
    }

    private void fillDoWalkChildren(Node node) {
        for (Node child : node.getChildren()) {
            child.setDoWalk(true);
            this.fillDoWalkChildren(child);
        }
    }

    private void fillTreeFromSNMP(Node node, TableUtils tutils) throws IOException {
        MibType mibType;
        if (!node.isDoWalk()) {
            return;
        }
        ObjectIdentifierValue oid = node.getObjectIdentifierValue();
        MibValueSymbol mibValueSymbol = oid.getSymbol();
        if (mibValueSymbol != null && (mibType = mibValueSymbol.getType()) instanceof SnmpObjectType) {
            SnmpObjectType snmpObjectType = (SnmpObjectType)mibType;
            MibType syntax = snmpObjectType.getSyntax();
            if (syntax instanceof SequenceType) {
                ArrayList<OID> oidList = new ArrayList<OID>();
                for (Node child : node.getChildren()) {
                    if (!child.isDoWalk()) continue;
                    ObjectIdentifierValue childOid = child.getObjectIdentifierValue();
                    oidList.add(new OID(childOid.getSymbol().getValue().toString()));
                }
                if (oidList.size() > 0) {
                    OID[] oids = oidList.toArray(new OID[oidList.size()]);
                    List table = tutils.getTable(this.getTarget(), oids, new OID("0"), null);
                    node.setTable(table);
                }
                return;
            }
            if (syntax instanceof BitSetType || syntax instanceof BooleanType || syntax instanceof ChoiceType || syntax instanceof IntegerType || syntax instanceof NullType || syntax instanceof ObjectIdentifierType || syntax instanceof RealType || syntax instanceof ElementType || syntax instanceof StringType || syntax instanceof TypeReference) {
                OID oid1 = new OID(node.getObjectIdentifierValue().toString());
                VariableBinding vb = this.getSingleVariable(oid1);
                node.setVb(vb);
            }
        }
        for (Node child : node.getChildren()) {
            this.fillTreeFromSNMP(child, tutils);
        }
    }

    private VariableBinding getSingleVariable(OID oid) throws IOException {
        PDU pdu = this.pduFactory.createPDU(this.getTarget());
        pdu.setType(-95);
        pdu.add(new VariableBinding(oid));
        ResponseEvent responseEvent = this.snmp.send(pdu, this.getTarget());
        PDU responsePDU = null;
        if (responseEvent != null) {
            responsePDU = responseEvent.getResponse();
        }
        VariableBinding vb = null;
        if (responsePDU != null) {
            vb = responsePDU.get(0);
        }
        return vb;
    }

    public static void main(String[] args) throws IOException, MibLoaderException {
        PDU response;
        MibLoaderHolder mibLoaderHolder = new MibLoaderHolder(new File("mibs"), false);
        SnmpUdpV2Manager snmpUdpv2Manager = new SnmpUdpV2Manager(mibLoaderHolder.getLoader(), "195.218.195.228", "public", 1, 1000, 65535, 161);
        String oid1 = "1.3.6.1.2.1.1.1.0";
        snmpUdpv2Manager.init();
        OID oid = new OID(oid1);
        OID[] oids = new OID[]{oid};
        ResponseEvent responseEvent = snmpUdpv2Manager.get(oids);
        if (responseEvent != null) {
            response = responseEvent.getResponse();
            if (response != null) {
                for (int i = 0; i < response.size(); ++i) {
                    VariableBinding vb1 = response.get(i);
                    System.out.println(vb1.toString());
                }
            }
        } else {
            System.out.println("PDU response event is null");
        }
        SnmpUdpV3Manager snmpUdpv3Manager = new SnmpUdpV3Manager(mibLoaderHolder.getLoader(), "195.218.195.228", 2, "usr-md5-none", "authkey1", "MD5", null, null, 2, 1000, 65535, 161);
        snmpUdpv3Manager.init();
        responseEvent = snmpUdpv3Manager.get(oids);
        if (responseEvent != null) {
            response = responseEvent.getResponse();
            if (response != null) {
                for (int i = 0; i < response.size(); ++i) {
                    VariableBinding vb1 = response.get(i);
                    System.out.println(vb1.getVariable().toString());
                }
            }
        } else {
            System.out.println("PDU response event is null");
        }
        SnmpXmlPrinter xmlPrinter = new SnmpXmlPrinter(mibLoaderHolder.getLoader(), snmpUdpv3Manager.walk(new String[]{"system", "interfaces"}));
        String xml = xmlPrinter.printTreeAsXML(true);
        System.out.println(xml);
    }

    private MibValueSymbol findSymbolFromMibs(String oidName) {
        Mib[] mibs = this.loader.getAllMibs();
        MibValueSymbol symbol11 = null;
        for (Mib mib : mibs) {
            symbol11 = (MibValueSymbol)mib.findSymbol(oidName, true);
            if (symbol11 == null) continue;
            return symbol11;
        }
        return null;
    }
}

