/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.IOException;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpManager;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.TcpTransportMappingFactory;
import net.percederberg.mibble.MibLoader;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TransportIpAddress;

public class SnmpTcpV3Manager
extends SnmpManager {
    protected String ver3Username;
    protected String ver3AuthPasscode;
    protected int ver3mode;
    protected String authenticationProtocol;
    protected String privacyProtocol;
    protected String privacyProtocolPassShare;
    protected TcpAddress tcpAddress;

    public SnmpTcpV3Manager(MibLoader loader, String ipAddress, int ver3mode, String ver3Username, String ver3AuthPasscode, String authenticationProtocol, String privacyProtocol, String privacyProtocolPassShare, int retries, int timeout, int maxSizeRequestPDU, int destinationPort) throws IOException {
        super(loader, retries, timeout, maxSizeRequestPDU, destinationPort, new TcpTransportMappingFactory(), (TransportIpAddress)new TcpAddress("0.0.0.0/0"));
        this.ver3mode = ver3mode;
        this.ver3Username = ver3Username;
        this.ver3AuthPasscode = ver3AuthPasscode;
        this.authenticationProtocol = authenticationProtocol;
        this.privacyProtocol = privacyProtocol;
        this.privacyProtocolPassShare = privacyProtocolPassShare;
        this.tcpAddress = new TcpAddress(ipAddress + "/" + destinationPort);
    }

    protected Target getTarget() {
        UserTarget target = new UserTarget();
        target.setAddress((Address)this.tcpAddress);
        target.setVersion(3);
        target.setRetries(this.retries);
        target.setTimeout((long)this.timeout);
        target.setSecurityLevel(this.ver3mode);
        target.setSecurityName(new OctetString(this.ver3Username));
        return target;
    }

    protected PDU createPDU() {
        return new ScopedPDU();
    }

    protected void doInit() {
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        OID authenticationProtocolOID = null;
        if ("MD5".equals(this.authenticationProtocol)) {
            authenticationProtocolOID = AuthMD5.ID;
        } else if ("SHA".equals(this.authenticationProtocol)) {
            authenticationProtocolOID = AuthSHA.ID;
        }
        OID privacyProtocolOID = null;
        if ("DES".equals(this.privacyProtocol)) {
            privacyProtocolOID = PrivDES.ID;
        } else if ("3DES".equals(this.privacyProtocol)) {
            privacyProtocolOID = Priv3DES.ID;
        }
        if (this.ver3mode == 1) {
            this.snmp.getUSM().addUser(new OctetString(this.ver3Username), new UsmUser(new OctetString(this.ver3Username), null, null, null, null));
        } else if (this.ver3mode == 2) {
            this.snmp.getUSM().addUser(new OctetString(this.ver3Username), new UsmUser(new OctetString(this.ver3Username), authenticationProtocolOID, new OctetString(this.ver3AuthPasscode), null, null));
        } else {
            this.snmp.getUSM().addUser(new OctetString(this.ver3Username), new UsmUser(new OctetString(this.ver3Username), authenticationProtocolOID, new OctetString(this.ver3AuthPasscode), privacyProtocolOID, new OctetString(this.privacyProtocolPassShare)));
        }
    }
}

