/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.IOException;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpManager;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.UdpTransportMappingFactory;
import net.percederberg.mibble.MibLoader;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;

public class SnmpUdpV2Manager
extends SnmpManager {
    protected String snmpCommunity;
    protected UdpAddress udpAddress;

    public SnmpUdpV2Manager(MibLoader loader, String ipAddress, String snmpCommunity, int retries, int timeout, int maxSizeRequestPDU, int destinationPort) throws IOException {
        super(loader, retries, timeout, maxSizeRequestPDU, destinationPort, new UdpTransportMappingFactory(), (TransportIpAddress)new UdpAddress("0.0.0.0/0"));
        this.snmpCommunity = snmpCommunity;
        this.udpAddress = new UdpAddress(ipAddress + "/" + destinationPort);
    }

    protected void doInit() {
    }

    protected Target getTarget() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.snmpCommunity));
        target.setAddress((Address)this.udpAddress);
        target.setRetries(this.retries);
        target.setTimeout((long)this.timeout);
        target.setVersion(1);
        return target;
    }

    protected PDU createPDU() {
        return new PDU();
    }
}

