/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.LogBasedMessageDispatcher;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.MessageDispatcherAbstractFactory;
import org.apache.log4j.Logger;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityProtocols;

public class LogBasedMessageDispatcherFactory
implements MessageDispatcherAbstractFactory {
    private File file;
    private static Pattern p = Pattern.compile("^(.*Running pending sync request with handle PduHandle\\[(.*)\\] and retry count left)(.*)$");
    private int instNum = 1;
    private BufferedReader reader;
    private static Logger logger = Logger.getLogger(LogBasedMessageDispatcherFactory.class);

    private LogBasedMessageDispatcherFactory(File file) {
        this.file = file;
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public MessageDispatcher createMessageDispatcherMapping() {
        int id = this.getNextId();
        logger.debug((Object)("Creating new message dispatcher id=" + id));
        LogBasedMessageDispatcher logBasedMessageDispatcher = new LogBasedMessageDispatcher(id);
        this.initMessageDispatcher(logBasedMessageDispatcher);
        return logBasedMessageDispatcher;
    }

    private int getNextId() {
        String msgIdStr = null;
        int i = 0;
        try {
            String s;
            while ((s = this.reader.readLine()) != null) {
                Matcher m = p.matcher(s);
                if (!m.find() || ++i != this.instNum) continue;
                msgIdStr = m.group(2);
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return Integer.parseInt(msgIdStr != null ? msgIdStr : null);
    }

    protected final void initMessageDispatcher(MessageDispatcher logBasedMessageDispatcher) {
        logBasedMessageDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        logBasedMessageDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        logBasedMessageDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv3());
        SecurityProtocols.getInstance().addDefaultProtocols();
    }
}

