/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.IOException;
import java.util.Map;
import net.itransformers.snmp2xml4j.snmptoolkit.SnmpManager;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.DefaultMessageDispatcherFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.UdpTransportMappingFactory;
import net.percederberg.mibble.MibLoader;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpUdpV2Manager
extends SnmpManager {
    protected String snmpCommunity;
    protected UdpAddress udpAddress;

    public SnmpUdpV2Manager(MibLoader loader, String ipAddress, String snmpCommunity, int retries, int timeout, int maxSizeRequestPDU, int maxRepetitions, int destinationPort) throws IOException {
        super(loader, retries, timeout, maxSizeRequestPDU, maxRepetitions, new UdpTransportMappingFactory(), (TransportIpAddress)new UdpAddress("0.0.0.0/0"));
        this.snmpCommunity = snmpCommunity;
        this.udpAddress = new UdpAddress(ipAddress + "/" + destinationPort);
    }

    public SnmpUdpV2Manager(MibLoader loader) {
        super(loader, new UdpTransportMappingFactory(), new DefaultMessageDispatcherFactory(), (TransportIpAddress)new UdpAddress("0.0.0.0/0"));
    }

    @Override
    protected void doInit() {
    }

    @Override
    public void doSetParameters(Map<String, String> conParams) {
        int destinationPort = super.convertStringToIntParam("destinationPort", conParams.get("destinationPort"), 161);
        this.udpAddress = new UdpAddress(conParams.get("ipAddress") + "/" + destinationPort);
        this.snmpCommunity = conParams.get("snmpCommunity");
    }

    @Override
    protected Target getTarget() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(this.snmpCommunity));
        target.setAddress((Address)this.udpAddress);
        target.setRetries(this.retries);
        target.setMaxSizeRequestPDU(this.maxSizeRequestPDU);
        target.setTimeout((long)this.timeout);
        target.setVersion(1);
        return target;
    }

    @Override
    protected PDU createPDU() {
        return new PDU();
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public UdpAddress getUdpAddress() {
        return this.udpAddress;
    }

    public void setUdpAddress(UdpAddress udpAddress) {
        this.udpAddress = udpAddress;
    }
}

