/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibValueSymbol;
import org.apache.log4j.Logger;

public class MibLoaderHolder {
    static Logger logger = Logger.getLogger(MibLoaderHolder.class);
    private MibLoader loader;

    public MibLoaderHolder(MibLoader loader) {
        this.loader = loader;
    }

    public MibLoaderHolder(File mibDir, boolean failOnError) throws IOException, MibLoaderException {
        this.loader = new MibLoader();
        this.loader.addDir(mibDir);
        File[] files = mibDir.listFiles(new FilenameFilter(){

            public boolean accept(File file, String s) {
                return !s.equals(".svn");
            }
        });
        if (files == null) {
            logger.error((Object)("Can not load mib files from dir: " + mibDir));
            throw new IOException("Can not load mib files from dir: " + mibDir.getAbsolutePath());
        }
        for (File file : files) {
            try {
                this.loader.load(file);
            }
            catch (MibLoaderException mle) {
                if (failOnError) {
                    throw mle;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                mle.getLog().printTo(new PrintWriter(bos));
                logger.warn((Object)new String(bos.toByteArray()));
            }
        }
    }

    public MibLoaderHolder(String[] mibFiles) throws IOException, MibLoaderException {
        this.loader = new MibLoader();
        this.loader.addDir(new File("mibs"));
        for (int i = 0; i < mibFiles.length; ++i) {
            this.loader.load(mibFiles[i]);
        }
    }

    public MibLoader getLoader() {
        return this.loader;
    }

    public String getSymbolByOid(String mibName, String oid) {
        MibValueSymbol symbolByOid;
        logger.debug((Object)("getSymbolByOid, mibName=" + mibName + ", oid=" + oid));
        Mib mib = this.loader.getMib(mibName);
        if (mib == null) {
            logger.error((Object)("Can not find symbol by mib, mibName=" + mibName + ", oid=" + oid));
        }
        MibValueSymbol mibValueSymbol = symbolByOid = mib != null ? mib.getSymbolByOid(oid) : null;
        if (symbolByOid == null) {
            logger.error((Object)("Can not find symbol by OID, mibName=" + mibName + ", oid=" + oid));
            return null;
        }
        logger.info((Object)symbolByOid.getName());
        return symbolByOid.getName();
    }

    public static void main(String[] args) throws IOException, MibLoaderException {
        String oid = "1.3.6.1.4.1.2636.1.1.1.2.1";
        MibLoaderHolder holder = new MibLoaderHolder(new File("snmptoolkit/mibs"), false);
        System.out.println(holder.getSymbolByOid("JUNIPER-CHASSIS-DEFINES-MIB", oid));
    }

    public static void main1(String[] args) throws IOException {
        String[] mibFiles = new String[]{"CISCO-CDP-MIB"};
        MibLoader loader = new MibLoader();
        loader.addDir(new File("mibs"));
        for (int i = 0; i < mibFiles.length; ++i) {
            try {
                loader.load(mibFiles[i]);
                continue;
            }
            catch (MibLoaderException e) {
                e.printStackTrace();
                e.getLog().printTo(System.out);
            }
        }
    }

    public void setLoader(MibLoader loader) {
        this.loader = loader;
    }
}

