/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import net.itransformers.snmp2xml4j.snmptoolkit.CmdOptions;
import net.itransformers.snmp2xml4j.snmptoolkit.CmdParser;
import net.itransformers.snmp2xml4j.snmptoolkit.MibLoaderHolder;
import net.itransformers.snmp2xml4j.snmptoolkit.Node;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.DefaultMessageDispatcherFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.messagedispacher.MessageDispatcherAbstractFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.TransportMappingAbstractFactory;
import net.itransformers.snmp2xml4j.snmptoolkit.transport.UdpTransportMappingFactory;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.BooleanType;
import net.percederberg.mibble.type.ChoiceType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.NullType;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.type.RealType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.TypeReference;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import org.apache.log4j.Logger;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Walk {
    static Logger logger = Logger.getLogger(Walk.class);
    private static MibLoaderHolder loader;
    private UdpAddress localAddress;
    private TransportMappingAbstractFactory transportFactory;
    private MessageDispatcherAbstractFactory messageDispatcherFactory;

    public Walk(MibLoader loader, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherFactory) throws IOException, MibLoaderException {
        this(new MibLoaderHolder(loader), transportFactory, messageDispatcherFactory);
        InetAddress localHost = InetAddress.getLocalHost();
        logger.info((Object)("Local address: " + localHost));
        this.localAddress = new UdpAddress(localHost, 0);
    }

    public Walk(File mibDir, boolean failOnError, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherFactory) throws IOException, MibLoaderException {
        this(new MibLoaderHolder(mibDir, failOnError), transportFactory, messageDispatcherFactory);
        this.localAddress = new UdpAddress("0.0.0.0/0");
    }

    public Walk(MibLoaderHolder loader, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherFactory) throws IOException {
        Walk.loader = loader;
        this.localAddress = new UdpAddress("0.0.0.0/0");
        this.transportFactory = transportFactory;
        this.messageDispatcherFactory = messageDispatcherFactory;
    }

    public Walk(String[] mibFiles, TransportMappingAbstractFactory transportFactory, MessageDispatcherAbstractFactory messageDispatcherFactory) throws IOException, MibLoaderException {
        this(new MibLoaderHolder(mibFiles), transportFactory, messageDispatcherFactory);
        InetAddress localHost = InetAddress.getLocalHost();
        logger.info((Object)("Local address: " + localHost));
        this.localAddress = new UdpAddress(localHost, 0);
    }

    public MibLoader getLoader() {
        return loader.getLoader();
    }

    public Node walk(String[] includes, Map parameters) throws IOException {
        ObjectIdentifierValue oid = this.getLoader().getRootOid();
        HashSet<String> includesSet = new HashSet<String>(Arrays.asList(includes));
        Node rootNode = new Node(oid, null);
        this.fillTreeFromMib(rootNode);
        this.fillDoWalk(rootNode, includesSet);
        this.fillTreeFromSNMP(rootNode, parameters);
        return rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTreeFromSNMP(Node root, Map parameters) throws IOException {
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        TransportMapping transport = this.transportFactory.createTransportMapping((TransportIpAddress)this.localAddress);
        MessageDispatcher dispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        Snmp snmp = new Snmp(dispatcher, transport);
        snmp.listen();
        try {
            SnmpConfigurator snmpConfig = new SnmpConfigurator();
            Target t = snmpConfig.getTarget(parameters);
            PDUFactory pduFactory = snmpConfig.getPDUFactory(parameters);
            TableUtils tutils = new TableUtils((Session)snmp, pduFactory);
            this.fillTreeFromSNMP(snmp, pduFactory, root, tutils, t);
        }
        finally {
            snmp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSNMPTable(Node root, Map parameters) throws IOException {
        CounterSupport.getInstance().addCounterListener((CounterListener)new DefaultCounterListener());
        TransportMapping transport = this.transportFactory.createTransportMapping((TransportIpAddress)this.localAddress);
        MessageDispatcher dispatcher = this.messageDispatcherFactory.createMessageDispatcherMapping();
        Snmp snmp = new Snmp(dispatcher, transport);
        snmp.listen();
        try {
            SnmpConfigurator snmpConfig = new SnmpConfigurator();
            Target t = snmpConfig.getTarget(parameters);
            PDUFactory pduFactory = snmpConfig.getPDUFactory(parameters);
            TableUtils tutils = new TableUtils((Session)snmp, pduFactory);
            this.createTableRow(snmp, pduFactory, root, tutils, t);
        }
        finally {
            snmp.close();
        }
    }

    private void createTableRow(Snmp snmp, PDUFactory pduFactory, Node node, TableUtils tutils, Target t) throws IOException {
        OID rowStatusOid = new OID("1.3.6.1.2.1.80.1.2.1.23");
        OID indexOid = new OID("1");
        VariableBinding[] rowValue = new VariableBinding[]{new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.23.1"), (Variable)new Integer32(1)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.4.1"), (Variable)new OctetString("4.2.2.2")), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.3.1"), (Variable)new Integer32(1)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.7.1"), (Variable)new Integer32(3)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.5.1"), (Variable)new Integer32(64)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.10.1"), (Variable)new Integer32(1)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.11.1"), (Variable)new Integer32(2)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.2.1.8.1"), (Variable)new Integer32(1)), new VariableBinding(new OID(".1.3.6.1.2.1.80.1.1.0"), (Variable)new OctetString("1"))};
        ResponseEvent responseEvent = tutils.createRow(t, rowStatusOid, indexOid, rowValue);
        logger.info((Object)("CreateRow response: " + responseEvent.getResponse()));
    }

    private void fillTreeFromSNMP(Snmp snmp, PDUFactory pduFactory, Node node, TableUtils tutils, Target t) throws IOException {
        MibType mibType;
        if (!node.isDoWalk()) {
            return;
        }
        ObjectIdentifierValue oid = node.getObjectIdentifierValue();
        MibValueSymbol mibValueSymbol = oid.getSymbol();
        if (mibValueSymbol != null && (mibType = mibValueSymbol.getType()) instanceof SnmpObjectType) {
            SnmpObjectType snmpObjectType = (SnmpObjectType)mibType;
            MibType syntax = snmpObjectType.getSyntax();
            if (syntax instanceof SequenceType) {
                ArrayList<OID> oidList = new ArrayList<OID>();
                boolean i = false;
                for (Node child : node.getChildren()) {
                    if (!child.isDoWalk()) continue;
                    ObjectIdentifierValue childOid = child.getObjectIdentifierValue();
                    oidList.add(new OID(childOid.getSymbol().getValue().toString()));
                }
                if (oidList.size() > 0) {
                    OID[] oids = oidList.toArray(new OID[oidList.size()]);
                    List table = tutils.getTable(t, oids, new OID("0"), null);
                    node.setTable(table);
                }
                return;
            }
            if (syntax instanceof BitSetType || syntax instanceof BooleanType || syntax instanceof ChoiceType || syntax instanceof IntegerType || syntax instanceof NullType || syntax instanceof ObjectIdentifierType || syntax instanceof RealType || syntax instanceof ElementType || syntax instanceof StringType || syntax instanceof TypeReference) {
                OID oid1 = new OID(node.getObjectIdentifierValue().toString());
                VariableBinding vb = this.getSingleVariable(snmp, pduFactory, t, oid1);
                node.setVb(vb);
            }
        }
        for (Node child : node.getChildren()) {
            this.fillTreeFromSNMP(snmp, pduFactory, child, tutils, t);
        }
    }

    private VariableBinding getSingleVariable(Snmp snmp, PDUFactory pduFactory, Target t, OID oid) throws IOException {
        PDU pdu = pduFactory.createPDU(t);
        pdu.setType(-95);
        pdu.add(new VariableBinding(oid));
        ResponseEvent responseEvent = snmp.send(pdu, t);
        PDU responsePDU = null;
        if (responseEvent != null) {
            responsePDU = responseEvent.getResponse();
        }
        VariableBinding vb = null;
        if (responsePDU != null) {
            vb = responsePDU.get(0);
        }
        return vb;
    }

    private void fillTreeFromMib(Node node) {
        ObjectIdentifierValue[] children;
        ObjectIdentifierValue oid = node.getObjectIdentifierValue();
        for (ObjectIdentifierValue child : children = oid.getAllChildren()) {
            if (child == null) continue;
            Node childNode = new Node(child, node);
            node.addChild(childNode);
            this.fillTreeFromMib(childNode);
        }
    }

    private void fillDoWalk(Node node, Set includes) {
        if (includes.contains(node.getObjectIdentifierValue().getName())) {
            for (Node currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
                currentNode.setDoWalk(true);
            }
            this.fillDoWalkChildren(node);
        }
        for (Node child : node.getChildren()) {
            this.fillDoWalk(child, includes);
        }
    }

    private void fillDoWalkChildren(Node node) {
        for (Node child : node.getChildren()) {
            child.setDoWalk(true);
            this.fillDoWalkChildren(child);
        }
    }

    public static String printTreeAsXML(Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<root>\n");
        Walk.printTreeAsXML(node, "", sb, false);
        sb.append("</root>");
        logger.trace((Object)sb.toString());
        return sb.toString();
    }

    public static String printTreeAsXML(Node node, boolean oidFlag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" ?>\n");
        sb.append("<root>\n");
        Walk.printTreeAsXML(node, "", sb, oidFlag);
        sb.append("</root>");
        logger.trace((Object)sb.toString());
        return sb.toString();
    }

    private static void printTreeAsXML(Node node, String tabs, StringBuilder sb, boolean oidFlag) {
        SnmpObjectType symbolType;
        if (node == null) {
            return;
        }
        if (!node.isDoWalk()) {
            return;
        }
        ObjectIdentifierValue objectIdentifierValue = node.getObjectIdentifierValue();
        if (objectIdentifierValue == null) {
            return;
        }
        String tagName = objectIdentifierValue.getName();
        MibValueSymbol symbol = node.getObjectIdentifierValue().getSymbol();
        String syntaxString = "";
        String snmpSyntax = "";
        String accessString = "";
        String description = "";
        String units = "";
        if (null != symbol && symbol.getType() instanceof SnmpObjectType) {
            symbolType = (SnmpObjectType)symbol.getType();
            MibType syntax = symbolType.getSyntax();
            syntaxString = symbolType.getName();
            snmpSyntax = Walk.determineSyntaxType(symbolType.getSyntax());
            SnmpAccess access = symbolType.getAccess();
            accessString = access.toString();
            description = symbolType.getDescription().replaceAll("\\n", " ");
            units = symbolType.getUnits();
        } else if (null != symbol && symbol.getType() instanceof ObjectIdentifierType) {
            symbolType = (ObjectIdentifierType)symbol.getType();
            syntaxString = symbolType.getName();
            snmpSyntax = Walk.determineSyntaxType((MibType)symbolType);
            accessString = "not-accessible";
            description = "";
        }
        if (node.getChildren() == null) {
            return;
        }
        if (node.getChildren().size() == 0) {
            String vb;
            VariableBinding vb1 = node.getVb();
            if (vb1 == null) {
                return;
            }
            Variable variable = vb1.getVariable();
            String string = vb = variable != null ? Walk.escapeForXML(variable.toString()) : "";
            if (oidFlag) {
                sb.append(String.format("\t%s<%s oid=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" access=\"%s\" units=\"%s\">", tabs, tagName, objectIdentifierValue, syntaxString, snmpSyntax, accessString, units));
                sb.append(String.format("\n\t\t%s<description><![CDATA[%s]]></description>", tabs, description));
                sb.append(String.format("\n\t\t%s<value>%s</value>", tabs, vb));
                sb.append(String.format("\n\t%s</%s>", tabs, tagName));
            } else {
                sb.append(String.format("\t%s<%s>%s</%s>", tabs, tagName, vb, tagName));
            }
            sb.append('\n');
            logger.trace((Object)sb.toString());
        } else if (node.getTable() != null) {
            Walk.printNodeTableAsXML(node, tabs, sb, oidFlag);
            logger.trace((Object)sb.toString());
        } else {
            StringBuilder sb1 = new StringBuilder();
            for (Node child : node.getChildren()) {
                Walk.printTreeAsXML(child, tabs + "\t", sb1, oidFlag);
            }
            if (oidFlag) {
                sb.append(String.format("%s<%s oid=\"%s\">", tabs, tagName, objectIdentifierValue));
            } else {
                sb.append(String.format("%s<%s>", tabs, tagName));
            }
            sb.append('\n');
            sb.append((CharSequence)sb1);
            sb.append(String.format("%s</%s>", tabs, tagName));
            sb.append('\n');
        }
    }

    static String escapeForXML(String s) {
        String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
        return s.replaceAll(xml10pattern, "").replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\u001c", "").replaceAll("\f", "").replaceAll("\u001a", "");
    }

    private static void printNodeTableAsXML(Node node, String tabs, StringBuilder sb, boolean oidFlag) {
        String tagName = node.getObjectIdentifierValue().getName();
        int i = 0;
        for (TableEvent tableEvent : node.getTable()) {
            StringBuilder sbTable = new StringBuilder();
            StringBuilder sbIndex = new StringBuilder();
            StringBuilder sbRows = new StringBuilder();
            Walk.printTableIndexAsXML(node, tabs, sbIndex, tableEvent.getIndex(), ++i, oidFlag);
            Walk.printTableRowsAsXML(node, tabs, sbRows, tableEvent.getColumns(), oidFlag);
            MibValueSymbol symbol = node.getObjectIdentifierValue().getSymbol();
            SnmpObjectType symbolType = (SnmpObjectType)symbol.getType();
            MibType syntax = symbolType.getSyntax();
            String syntaxString = syntax.getName();
            String snmpSyntax = Walk.determineSyntaxType(syntax);
            SnmpAccess access = symbolType.getAccess();
            String accessString = access.toString();
            String description = symbolType.getDescription().replaceAll("\\n", " ");
            String units = symbolType.getUnits();
            if (oidFlag) {
                sbTable.append(String.format("%s<%s oid=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" access=\"%s\" units=\"%s\">", tabs, tagName, node.getObjectIdentifierValue(), syntaxString, snmpSyntax, accessString, units));
                sbTable.append(String.format("\n\t%s<description><![CDATA[%s]]></description>", tabs, description));
            } else {
                sbTable.append(String.format("%s<%s>", tabs, tagName));
            }
            sbTable.append('\n');
            sbTable.append((CharSequence)sbIndex);
            sbTable.append((CharSequence)sbRows);
            sbTable.append(String.format("\n%s</%s>", tabs, tagName));
            sbTable.append('\n');
            sb.append((CharSequence)sbTable);
        }
    }

    private static void printTableRowsAsXML(Node node, String tabs, StringBuilder sb4, VariableBinding[] cols, boolean oidFlag) {
        if (cols == null) {
            return;
        }
        for (VariableBinding vb : cols) {
            Variable variable;
            ObjectIdentifierValue objectIdentifierValue;
            if (vb == null) continue;
            String childTagName = null;
            for (Node child : node.getChildren()) {
                objectIdentifierValue = child.getObjectIdentifierValue();
                if (objectIdentifierValue == null) continue;
                try {
                    if (vb.getOid() == null || !vb.getOid().startsWith(new OID(objectIdentifierValue.toString()))) continue;
                    childTagName = objectIdentifierValue.getName();
                }
                catch (RuntimeException rte) {
                    logger.error((Object)rte.getMessage(), (Throwable)rte);
                }
            }
            if (childTagName == null || (variable = vb.getVariable()) == null) continue;
            String var = Walk.escapeForXML(variable.toString());
            if (oidFlag) {
                objectIdentifierValue = node.getObjectIdentifierValue();
                MibValueSymbol mibValueSymbol = objectIdentifierValue.getSymbol();
                if (mibValueSymbol == null) {
                    return;
                }
                ObjectIdentifierValue childByName = objectIdentifierValue.getChildByName(childTagName);
                MibValueSymbol symbol = childByName.getSymbol();
                SnmpObjectType symbolType = (SnmpObjectType)symbol.getType();
                MibType syntax = symbolType.getSyntax();
                String syntaxString = syntax.getName();
                String snmpSyntax = Walk.determineSyntaxType(syntax);
                SnmpAccess access = symbolType.getAccess();
                String description = symbolType.getDescription().replaceAll("\\n", " ");
                String accessString = access.toString();
                String units = symbolType.getUnits();
                sb4.append(String.format("\t%s<%s oid=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" access=\"%s\" units=\"%s\">", tabs, childTagName, vb.getOid(), syntaxString, snmpSyntax, accessString, units));
                sb4.append(String.format("\n\t\t%s<description><![CDATA[%s]]></description>", tabs, description));
                sb4.append(String.format("\n\t\t%s<value>%s</value>", tabs, var));
                sb4.append(String.format("\n\t%s</%s>", tabs, childTagName));
                continue;
            }
            sb4.append(String.format("\n\t%s<%s>%s</%s>", tabs, childTagName, var, childTagName));
        }
    }

    private static void printTableIndexAsXML(Node node, String tabs, StringBuilder sb, OID indexOID, int instanceIndex, boolean oidFlag) {
        if (node == null) {
            return;
        }
        ObjectIdentifierValue objectIdentifierValue = node.getObjectIdentifierValue();
        if (objectIdentifierValue == null) {
            return;
        }
        MibValueSymbol mibValueSymbol = objectIdentifierValue.getSymbol();
        if (mibValueSymbol == null) {
            return;
        }
        SnmpObjectType snmpObjectType = (SnmpObjectType)mibValueSymbol.getType();
        if (snmpObjectType == null) {
            return;
        }
        ArrayList indexes = snmpObjectType.getIndex();
        if (indexOID != null) {
            StringBuffer instance = new StringBuffer();
            StringBuffer instanceValues = new StringBuffer();
            if (indexes != null && indexes.size() > 0) {
                int pos = 0;
                for (int i = 0; i < indexes.size(); ++i) {
                    try {
                        SnmpAccess access;
                        MibType syntax;
                        SnmpIndex index = (SnmpIndex)indexes.get(i);
                        String indexName = index.getValue().getName();
                        ObjectIdentifierValue childByName = objectIdentifierValue.getChildByName(indexName);
                        MibValueSymbol symbol = null;
                        String syntaxString = "UNKNOWN";
                        String accessString = "UNKNOWN";
                        String snmpSyntax = "UNKNOWN";
                        if (childByName != null) {
                            symbol = childByName.getSymbol();
                            SnmpObjectType indexType = (SnmpObjectType)symbol.getType();
                            syntax = indexType.getSyntax();
                            syntaxString = syntax.getName();
                            access = indexType.getAccess();
                            accessString = access.toString();
                            String indexVal = new OID(indexOID.getValue(), pos, 1).toString();
                            snmpSyntax = Walk.determineSyntaxType(syntax);
                            boolean posIncremented = false;
                            if (syntax instanceof StringType && syntaxString.equals("OCTET STRING")) {
                                Constraint constraint = ((StringType)syntax).getConstraint();
                                if (constraint instanceof SizeConstraint) {
                                    ArrayList list = ((SizeConstraint)constraint).getValues();
                                    if (list.size() == 1) {
                                        Constraint constraint1 = (Constraint)list.get(0);
                                        if (constraint1 instanceof ValueConstraint) {
                                            MibValue val = ((ValueConstraint)constraint1).getValue();
                                            if (val instanceof NumberValue) {
                                                NumberValue numVal = (NumberValue)val;
                                                Number number = (Number)numVal.toObject();
                                                int size = number.intValue();
                                                indexVal = new OID(indexOID.getValue(), pos, size).toString();
                                                pos += size;
                                                posIncremented = true;
                                            }
                                        } else {
                                            indexVal = constraint1 instanceof ValueRangeConstraint ? OctetString.fromString((String)new OID(indexOID.getValue(), i + 1, indexOID.getValue().length - (i + 1)).toString(), (char)'.', (int)10).toString() : new OID(indexOID.getValue()).toString();
                                        }
                                    } else {
                                        indexVal = new OID(indexOID.getValue()).toString();
                                    }
                                } else {
                                    indexVal = new OID(indexOID.getValue()).toString();
                                }
                            }
                            if (oidFlag) {
                                sb.append(String.format("\t%s<index name=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" oid=\"%s\" access=\"%s\">%s</index>\n", tabs, indexName, syntaxString, snmpSyntax, index, accessString, Walk.escapeForXML(indexVal)));
                            } else {
                                sb.append(String.format("\t%s<index name=\"%s\">%s</index>\n", tabs, indexName, Walk.escapeForXML(indexVal)));
                            }
                            if (i != indexes.size() - 1) {
                                instance.append(indexName + "");
                                instanceValues.append(indexVal + "");
                            } else {
                                instance.append(indexName);
                                instanceValues.append(indexVal);
                            }
                            if (posIncremented) continue;
                            ++pos;
                            continue;
                        }
                        MibValueSymbol symbol11 = Walk.findSymbolFromMibs(indexName);
                        if (symbol11 != null) {
                            syntax = symbol11.getType();
                            access = ((SnmpObjectType)syntax).getAccess();
                            accessString = access.toString();
                            syntaxString = ((SnmpObjectType)syntax).getSyntax().getName();
                            snmpSyntax = Walk.determineSyntaxType(((SnmpObjectType)syntax).getSyntax());
                        }
                        OID indexVal = new OID(indexOID.getValue(), pos, 1);
                        if (oidFlag) {
                            sb.append(String.format("\t%s<index name=\"%s\" primitiveSyntax=\"%s\" snmpSyntax =\"%s\" oid=\"%s\" access=\"%s\">%s</index>\n", tabs, indexName, syntaxString, snmpSyntax, index, accessString, Walk.escapeForXML(indexVal.toString())));
                        } else {
                            sb.append(String.format("\t%s<index name=\"%s\">%s</index>\n", tabs, indexName, Walk.escapeForXML(indexVal.toString())));
                        }
                        if (i != indexes.size() - 1) {
                            instance.append(indexName + "");
                            instanceValues.append(indexVal + "");
                            continue;
                        }
                        instance.append(indexName + ".");
                        instanceValues.append(indexVal + ".");
                        continue;
                    }
                    catch (RuntimeException e) {
                        logger.trace((Object)sb.toString());
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            sb.append(String.format("\t%s<instance instanceIndex=\"%s\" instanceName=\"%s\" instanceValue=\"%s\">%s</instance>\n", tabs, instanceIndex, instance.toString(), Walk.escapeForXML(instanceValues.toString()), Walk.escapeForXML(indexOID.toString())));
        }
    }

    public static void main(String[] args) throws IOException, MibLoaderException, XPathExpressionException, SAXException, ParserConfigurationException {
        Properties parameters;
        Map<CmdOptions, String> opts;
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        boolean oidFlag = false;
        try {
            opts = CmdParser.parseCmd(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            CmdParser.printWalkUsage();
            return;
        }
        String mibDir = opts.get((Object)CmdOptions.MIBS_DIR);
        if (mibDir == null) {
            System.out.println("Missing option \"-" + CmdOptions.MIBS_DIR.getName() + "\"");
            CmdParser.printWalkUsage();
            return;
        }
        Walk walker = new Walk(new File(mibDir), false, new UdpTransportMappingFactory(), new DefaultMessageDispatcherFactory());
        if (opts.containsKey((Object)CmdOptions.PRINT_LOADED_MIBS)) {
            Mib[] allMibs;
            for (Mib mib : allMibs = walker.getLoader().getAllMibs()) {
                System.out.println("MIB: " + mib.getName() + ", file=" + mib.getFile());
            }
        }
        if (Walk.fillParams(opts, parameters = new Properties())) {
            return;
        }
        StringBuffer finalXmlBuffer = new StringBuffer();
        ArrayList<String> includesList = new ArrayList<String>();
        String oids = opts.get((Object)CmdOptions.OIDS);
        if (oids == null) {
            System.out.println("Missing option \"-" + CmdOptions.OIDS.getName());
            CmdParser.printWalkUsage();
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(oids, " ,;");
        while (tokenizer.hasMoreTokens()) {
            includesList.add(tokenizer.nextToken());
        }
        Node root = walker.walk(includesList.toArray(new String[includesList.size()]), parameters);
        String xml = Walk.printTreeAsXML(root, oidFlag);
        finalXmlBuffer.append(xml);
        Walk.outputXml(opts, finalXmlBuffer.toString());
    }

    public static void outputXml(Map<CmdOptions, String> opts, String finalXml) throws FileNotFoundException {
        String outputFile = opts.get((Object)CmdOptions.OUTPUT_FILE);
        if (outputFile == null) {
            System.out.println(finalXml);
        } else {
            PrintWriter writer = new PrintWriter(outputFile);
            writer.print(finalXml);
            writer.flush();
            writer.close();
        }
    }

    public static boolean fillParams(Map<CmdOptions, String> opts, Properties parameters) {
        String address = opts.get((Object)CmdOptions.ADDRESS);
        if (address == null) {
            System.out.println("Missing option \"-" + CmdOptions.ADDRESS.getName() + "\"");
            CmdParser.printWalkUsage();
            return true;
        }
        parameters.put("address", Arrays.asList(address));
        String community = opts.get((Object)CmdOptions.COMMUNITY);
        if (community == null) {
            System.out.println("Missing option \"-" + CmdOptions.COMMUNITY.getName() + "\"");
            CmdParser.printWalkUsage();
            return true;
        }
        parameters.put("c", Arrays.asList(community));
        String version = opts.get((Object)CmdOptions.VERSION);
        if (version == null) {
            System.out.println("Missing option \"-" + CmdOptions.VERSION.getName() + "\"");
            CmdParser.printWalkUsage();
            return true;
        }
        parameters.put("v", Arrays.asList(version));
        String timeout = opts.get((Object)CmdOptions.TIMEOUT);
        if (timeout != null) {
            int timeoutInt;
            try {
                timeoutInt = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid parameter value for \"-" + (Object)((Object)CmdOptions.RETRIES) + "\", int value is required");
                CmdParser.printWalkUsage();
                return true;
            }
            parameters.put("t", Arrays.asList(timeoutInt));
        } else {
            System.out.println("Using default timeout: 1000");
            parameters.put("t", Arrays.asList(1000));
        }
        String retries = opts.get((Object)CmdOptions.RETRIES);
        if (retries != null) {
            int retriesInt;
            try {
                retriesInt = Integer.parseInt(retries);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid parameter value for \"-" + (Object)((Object)CmdOptions.RETRIES) + "\", int value is required");
                CmdParser.printWalkUsage();
                return true;
            }
            parameters.put("r", Arrays.asList(retriesInt));
        } else {
            System.out.println("Using default retries: 1");
            parameters.put("r", Arrays.asList(1));
        }
        String maxRepetitions = opts.get((Object)CmdOptions.MAX_REPETITIONS);
        if (maxRepetitions != null) {
            int maxRepetitionsInt;
            try {
                maxRepetitionsInt = Integer.parseInt(maxRepetitions);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid parameter value for \"-" + (Object)((Object)CmdOptions.MAX_REPETITIONS) + "\", int value is required");
                CmdParser.printWalkUsage();
                return true;
            }
            parameters.put("Cr", Arrays.asList(maxRepetitionsInt));
        } else {
            System.out.println("Using default maxRepetitions: 10");
            parameters.put("Cr", Arrays.asList(1000));
        }
        return false;
    }

    private static String determineSyntaxType(MibType syntax) {
        if (syntax.getTag() != null) {
            if (syntax.getTag().getCategory() == 1) {
                return syntax.getReferenceSymbol().getName();
            }
            if (syntax.getTag().getCategory() == 0) {
                return syntax.getName();
            }
            if (syntax.getTag().getCategory() == 2) {
                return syntax.getName();
            }
            return syntax.getName();
        }
        return syntax.getName();
    }

    private static MibValueSymbol findSymbolFromMibs(String oidName) {
        Mib[] mibs = loader.getLoader().getAllMibs();
        MibValueSymbol symbol11 = null;
        for (int i = 0; i < mibs.length; ++i) {
            symbol11 = (MibValueSymbol)mibs[i].findSymbol(oidName, true);
            if (symbol11 == null) continue;
            return symbol11;
        }
        return symbol11;
    }
}

