/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.itransformers.snmp2xml4j.snmptoolkit.transform.XsltTransformer;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class XsltExecutor {
    public static void main(String[] args) throws IOException {
        String deviceOS;
        if (args.length != 3 && args.length != 4) {
            System.out.println("Missing input parameters");
            System.out.println(" Example usage: xsltTransform.sh /home/test/test.xslt /usr/data/Input.xml /usr/data/Output.xml ");
            return;
        }
        String inputXslt = args[0];
        if (inputXslt == null) {
            System.out.println("Missing input xslt file path");
            System.out.println(" Example usage: xsltTransformer.sh /home/test/test.xslt /usr/data/Input.xml /usr/data/Output.xml");
            return;
        }
        String inputFilePath = args[1];
        if (inputFilePath == null) {
            System.out.println("Missing input xml file path");
            System.out.println(" Example usage: xsltTransformer.sh /home/test/test.xslt /usr/data/Input.xml /usr/data/Output.xml");
            return;
        }
        String outputFilePath = args[2];
        if (outputFilePath == null) {
            System.out.println("Missing output file path");
            System.out.println(" Example usage: xsltTransformer.sh /home/test/test.xslt /usr/data/Input.xml /usr/data/Output.xml");
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (args.length == 4 && (deviceOS = args[3]) != null) {
            params.put("DeviceOS", deviceOS);
        }
        ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
        File xsltFileName1 = new File(inputXslt);
        FileInputStream inputStream1 = new FileInputStream(new File(inputFilePath));
        XsltTransformer xsltTransformer = new XsltTransformer();
        try {
            xsltTransformer.transformXML(inputStream1, xsltFileName1, outputStream1, params);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        FileUtils.writeStringToFile((File)new File(outputFilePath), (String)new String(outputStream1.toByteArray()));
        System.out.println("Done! please review the transformed file " + outputFilePath);
    }
}

