/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit.transport;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class LinuxInetAddress {
    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        if (!localHost.isLoopbackAddress()) {
            return localHost;
        }
        InetAddress[] addrs = LinuxInetAddress.getAllLocalUsingNetworkInterface();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i].isLoopbackAddress()) continue;
            return addrs[i];
        }
        return localHost;
    }

    public static InetAddress[] getAllLocal() throws UnknownHostException {
        InetAddress[] iAddresses = InetAddress.getAllByName("127.0.0.1");
        if (iAddresses.length != 1) {
            return iAddresses;
        }
        if (!iAddresses[0].isLoopbackAddress()) {
            return iAddresses;
        }
        return LinuxInetAddress.getAllLocalUsingNetworkInterface();
    }

    private static InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                addresses.add(e2.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i = 0; i < iAddresses.length; ++i) {
            iAddresses[i] = (InetAddress)addresses.get(i);
        }
        return iAddresses;
    }

    public static InetAddress getLocalHostAddress(InetAddress intendedDestination) throws SocketException {
        DatagramSocket sock = new DatagramSocket();
        sock.getLocalPort();
        sock.connect(intendedDestination, sock.getLocalPort());
        return sock.getLocalAddress();
    }
}

