/*
 * Decompiled with CFR 0.152.
 */
package net.itransformers.snmp2xml4j.snmptoolkit;

import java.util.HashMap;
import java.util.Map;
import net.itransformers.snmp2xml4j.snmptoolkit.CmdOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmdParser {
    CmdParser() {
    }

    public static Map<CmdOptions, String> parseCmd(String[] args) throws Exception {
        HashMap<CmdOptions, String> result = new HashMap<CmdOptions, String>();
        block0: for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            for (CmdOptions cmdOpt : CmdOptions.values()) {
                if (!opt.equals("-" + cmdOpt.getName())) continue;
                if (cmdOpt.getValueSize() == 0) continue block0;
                if (cmdOpt.getValueSize() == 1) {
                    if (i + 1 < args.length) {
                        result.put(cmdOpt, args[i + 1]);
                        continue;
                    }
                    throw new Exception("missing value for \"-" + cmdOpt.getName() + "\" option");
                }
                throw new RuntimeException("Unsupported value size");
            }
        }
        return result;
    }

    public static void printUsage() {
        System.out.println("Usage: java -jar snmp2xml4j.jar -O <get|walk> -v <version> -a <address> -p <port> -pr <protocol> -c <community> -u <security_name> -aa <auth-level> -A <auth_passphrare> -ap <auth_protocol> -pp <priv_protocol> -Y <priv_passphrase> -t <timeout> -r <retries> -m <max_repetitions> [-f <output_file>] -o <oid_names>");
        System.out.println("Example v1/v2c: java -jar snmp2xml4j.jar -O <get|walk>  -v 2c -a 195.218.195.228 -p 161 -pr udp -c public -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, sysName\"");
        System.out.println("Example v3c: java -jar snmp2xml4j.jar -O <get|walk> -v 3 -a 195.218.195.228 -p 161 -pr udp -aa AUTH_NOPRIV -u usr-md5-none -A authkey1 -ap MD5 -t 1000 -r 1 -m 100 -f out.xml -o \"sysDescr, sysName\"");
    }
}

