/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ExtJsApi {
    private static final Pattern CONSTANT_NAME_PATTERN = Pattern.compile("[A-Z][A-Z0-9_]*");
    private Set<ExtClass> extClasses;
    private Map<String, ExtClass> extClassByName = new HashMap<String, ExtClass>();
    private Set<ExtClass> mixins;

    private static ExtClass readExtApiJson(File jsonFile) throws IOException {
        System.out.printf("Reading API from %s...\n", jsonFile.getPath());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerSubtypes(new Class[]{Property.class, Cfg.class, Method.class, Event.class});
        return (ExtClass)objectMapper.readValue(jsonFile, ExtClass.class);
    }

    public <T extends Member> List<T> filterByOwner(boolean isInterface, boolean isStatic, ExtClass owner, List<Member> members, Class<T> memberType) {
        HashSet<String> superclassNames = new HashSet<String>();
        for (ExtClass superclass : this.computeTransitiveSupersAndMixins(this.getSuperClass(owner))) {
            superclassNames.add(superclass.name);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Member member : members) {
            if (!memberType.isInstance(member) || member.meta.removed != null || member.static_ != isStatic || member.private_ || member.autodetected != null && member.autodetected.containsKey("tagname") || superclassNames.contains(member.owner) || isInterface && !ExtJsApi.isPublicNonStaticMethodOrPropertyOrCfg(member)) continue;
            result.add(memberType.cast(member));
        }
        return result;
    }

    private static <T extends Member> T resolve(ExtClass owner, String name, Class<T> memberType) {
        if (owner != null) {
            for (Member member : owner.members) {
                if (!memberType.isInstance(member) || !member.owner.equals(owner.name) || !name.equals(member.name) || member.meta.static_) continue;
                return (T)((Member)memberType.cast(member));
            }
        }
        return null;
    }

    public boolean inheritsDoc(Member member) {
        if (member.overrides != null && !member.overrides.isEmpty()) {
            Overrides override = member.overrides.get(0);
            Object superMember = ExtJsApi.resolve(this.getExtClass(override.owner), override.name, member.getClass());
            if (superMember != null && ((Member)superMember).doc != null) {
                String normalizedDoc = member.doc.replace(member.owner, ((Member)superMember).owner);
                return normalizedDoc.equals(((Member)superMember).doc);
            }
        }
        return false;
    }

    public boolean isStatic(Member member) {
        ExtClass extClass = this.getExtClass(member.owner);
        return !extClass.singleton && (member.static_ || member.meta.static_ || ExtJsApi.isConstantName(member.name));
    }

    private static boolean isConstantName(String name) {
        return CONSTANT_NAME_PATTERN.matcher(name).matches();
    }

    public boolean isReadOnly(Member member) {
        return member.meta.readonly || member.readonly || ExtJsApi.isConstantName(member.name);
    }

    public boolean isProtected(Member member) {
        return member.protected_ || member.meta.protected_;
    }

    public static boolean isPublicNonStaticMethodOrPropertyOrCfg(Member member) {
        return (member instanceof Method || member instanceof Property || member instanceof Cfg) && !member.meta.static_ && !member.meta.private_ && !member.private_ && !member.meta.protected_ && !member.protected_ && !"constructor".equals(member.name);
    }

    public static boolean isConst(Member member) {
        return member.meta.readonly || member.readonly || member.name.equals(member.name.toUpperCase()) && member.default_ != null;
    }

    public ExtJsApi(File[] files) throws IOException {
        this.extClasses = new LinkedHashSet<ExtClass>();
        for (File jsonFile : files) {
            ExtClass extClass = ExtJsApi.readExtApiJson(jsonFile);
            this.extClasses.add(extClass);
            this.extClassByName.put(extClass.name, extClass);
            if (extClass.alternateClassNames == null) continue;
            for (String alternateClassName : extClass.alternateClassNames) {
                this.extClassByName.put(alternateClassName, extClass);
            }
        }
        HashSet<ExtClass> collectMixins = new HashSet<ExtClass>();
        for (ExtClass extClass : this.extClasses) {
            for (String mixin : extClass.mixins) {
                ExtClass mixinClass = this.getExtClass(mixin);
                if (mixinClass == null) continue;
                collectMixins.add(mixinClass);
            }
        }
        this.markTransitiveSupersAsMixins(collectMixins);
        this.mixins = Collections.unmodifiableSet(collectMixins);
        this.extClasses = Collections.unmodifiableSet(this.extClasses);
    }

    private void markTransitiveSupersAsMixins(Set<ExtClass> extClasses) {
        Set<ExtClass> supers = this.supers(extClasses);
        while (!supers.isEmpty()) {
            extClasses.addAll(supers);
            supers = this.supers(supers);
        }
    }

    private Set<ExtClass> computeTransitiveSupersAndMixins(ExtClass extClass) {
        HashSet<ExtClass> result = new HashSet<ExtClass>();
        this.addTransitiveSupersAndMixins(result, extClass);
        return result;
    }

    private boolean addTransitiveSupersAndMixins(Set<ExtClass> supersAndMixins, ExtClass extClass) {
        if (extClass != null && supersAndMixins.add(extClass)) {
            this.addTransitiveSupersAndMixins(supersAndMixins, this.getSuperClass(extClass));
            for (String mixin : extClass.mixins) {
                this.addTransitiveSupersAndMixins(supersAndMixins, this.getExtClass(mixin));
            }
            return true;
        }
        return false;
    }

    private Set<ExtClass> supers(Set<ExtClass> extClasses) {
        HashSet<ExtClass> result = new HashSet<ExtClass>();
        for (ExtClass extClass : extClasses) {
            ExtClass superclass = this.getSuperClass(extClass);
            if (superclass == null) continue;
            result.add(superclass);
        }
        return result;
    }

    public Set<ExtClass> getExtClasses() {
        return this.extClasses;
    }

    public ExtClass getExtClass(String name) {
        return this.extClassByName.get(name);
    }

    public ExtClass getSuperClass(ExtClass extClass) {
        return this.getExtClass(extClass.extends_);
    }

    public Set<ExtClass> getMixins() {
        return this.mixins;
    }

    public static boolean isSingleton(ExtClass extClass) {
        return extClass != null && extClass.singleton;
    }

    @JsonIgnoreProperties(value={"aside", "chainable", "preventable"})
    public static class Meta {
        @JsonProperty(value="protected")
        public boolean protected_;
        @JsonProperty(value="private")
        public boolean private_;
        public boolean readonly;
        @JsonProperty(value="static")
        public boolean static_;
        @JsonProperty(value="abstract")
        public boolean abstract_;
        public boolean markdown;
        public Deprecation deprecated;
        public String template;
        public List<String> author;
        public List<String> docauthor;
        public boolean required;
        public Map<String, String> removed;
        public String since;
    }

    @JsonTypeName(value="event")
    @JsonIgnoreProperties(value={"html_type", "html_meta", "short_doc", "localdoc", "linenr", "return", "throws"})
    public static class Event
    extends Member {
        public List<Param> params;
        public boolean preventable;
    }

    @JsonTypeName(value="method")
    @JsonIgnoreProperties(value={"html_type", "html_meta", "short_doc", "localdoc", "linenr", "throws", "fires", "method_calls", "template", "required"})
    public static class Method
    extends Member {
        public List<Param> params;
        @JsonProperty(value="return")
        public Param return_;
        public boolean chainable;
        @JsonProperty(value="abstract")
        public boolean abstract_;
    }

    @JsonTypeName(value="params")
    public static class Param
    extends Var {
        public boolean optional;
        public Object ext4_auto_param;
    }

    @JsonTypeName(value="property")
    @JsonIgnoreProperties(value={"html_type", "html_meta", "short_doc", "localdoc", "linenr", "params", "return", "throws", "chainable"})
    public static class Property
    extends Member {
        public String toString() {
            return this.meta + "var " + super.toString();
        }
    }

    public static class Overrides {
        public String name;
        public String owner;
        public String id;
        public String link;
    }

    public static class MemberReference
    extends Tag {
        public String cls;
        public String member;
        public String type;
    }

    @JsonTypeName(value="cfg")
    @JsonIgnoreProperties(value={"html_type", "html_meta", "short_doc", "localdoc", "linenr", "params", "fires", "throws", "return"})
    public static class Cfg
    extends Member {
        public boolean required;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="tagname")
    @JsonIgnoreProperties(value={"html_type", "html_meta", "short_doc", "localdoc", "linenr"})
    public static class Member
    extends Var {
        public String owner;
        public Deprecation deprecated;
        public String since;
        @JsonProperty(value="static")
        public boolean static_;
        public Meta meta = new Meta();
        public boolean inheritable;
        public String id;
        public List<FilenNameAndLineNumber> files;
        public boolean accessor;
        public boolean evented;
        public List<Overrides> overrides;
        @JsonProperty(value="protected")
        public boolean protected_;
        public boolean readonly;
        public Map<String, Object> autodetected;
    }

    @JsonIgnoreProperties(value={"html_type", "html_meta", "linenr"})
    public static abstract class Var
    extends Tag {
        public String type;
        @JsonProperty(value="default")
        public String default_;
    }

    public static class Deprecation {
        public String text;
        public String version;
    }

    public static class FilenNameAndLineNumber {
        public String filename;
        public String linenr;
        public String href;
    }

    @JsonIgnoreProperties(value={"html_meta", "html_type", "short_doc", "localdoc", "linenr", "enum", "override", "autodetected", "params"})
    public static class ExtClass
    extends Tag {
        public Deprecation deprecated;
        public String since;
        @JsonProperty(value="extends")
        public String extends_;
        public List<String> mixins = Collections.emptyList();
        public List<String> alternateClassNames;
        public Map<String, List<String>> aliases;
        public boolean singleton;
        public List<String> requires;
        public List<String> uses;
        public String code_type;
        public boolean inheritable;
        public Meta meta;
        public String id;
        public List<Member> members;
        public List<FilenNameAndLineNumber> files;
        public boolean component;
        public List<String> superclasses;
        public List<String> subclasses;
        public List<String> mixedInto;
        public List<String> parentMixins;
        @JsonProperty(value="abstract")
        public boolean abstract_;
        @JsonProperty(value="protected")
        public boolean protected_;
    }

    @JsonIgnoreProperties(value={"html_meta", "html_type", "short_doc", "localdoc", "linenr"})
    public static class Tag {
        public String tagname;
        public String name;
        public String doc = "";
        @JsonProperty(value="private")
        public boolean private_;
        public MemberReference inheritdoc;
        public Object author;
        public Object docauthor;
        public Object removed;
        public List<Param> properties;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.name.equals(tag.name) && !(this.tagname == null ? tag.tagname != null : !this.tagname.equals(tag.tagname));
        }

        public int hashCode() {
            int result = this.tagname != null ? this.tagname.hashCode() : 0;
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

