/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class ExtJsApi {
    private static final Pattern CONSTANT_NAME_PATTERN = Pattern.compile("[A-Z][A-Z0-9_]*");
    private Set<ExtClass> extClasses;
    private Map<String, ExtClass> extClassByName;
    private Set<ExtClass> mixins;
    private String version;

    private static Doxi readExtApiJson(File jsonFile) throws IOException {
        System.out.printf("Reading API from %s...\n", jsonFile.getPath());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return (Doxi)objectMapper.readValue(jsonFile, Doxi.class);
    }

    public <T extends Member> List<T> filterByOwner(boolean isInterface, boolean isStatic, ExtClass owner, String membersTypeName, Class<T> memberType) {
        return this.filterByOwner(false, isInterface, isStatic, owner, membersTypeName, memberType);
    }

    public <T extends Member> List<T> filterByOwner(boolean isMixin, boolean isInterface, boolean isStatic, ExtClass owner, String membersTypeName, Class<T> memberType) {
        ArrayList<T> result = new ArrayList<T>();
        Optional<Members> membersWithType = owner.items.stream().filter(members -> membersTypeName.equals(members.$type)).findFirst();
        List members2 = membersWithType.isPresent() ? membersWithType.get().items : Collections.emptyList();
        for (Member member : members2) {
            if (!memberType.isInstance(member) || member.static_ != isStatic || "private".equals(member.access) || isInterface && !ExtJsApi.isPublicNonStaticMethodOrPropertyOrCfg(member) || isMixin && ExtJsApi.isPublicNonStaticMethodOrPropertyOrCfg(member)) continue;
            result.add(memberType.cast(member));
        }
        return result;
    }

    public <T extends Tag> T resolve(String reference, String thisClassName, Class<T> memberType) {
        String[] parts = reference.split("[#-]");
        String className = parts[0].isEmpty() ? thisClassName : parts[0];
        ExtClass owner = this.getExtClass(className);
        if (parts.length == 1) {
            return (T)((Tag)memberType.cast(owner));
        }
        String name = parts[parts.length - 1];
        return this.resolve(owner, name, memberType);
    }

    private <T extends Tag> T resolve(ExtClass owner, String name, Class<T> memberType) {
        if (owner != null) {
            for (Members members : owner.items) {
                for (Member member : members.items) {
                    if (!name.equals(member.name) || !memberType.isInstance(member)) continue;
                    return (T)((Tag)memberType.cast(member));
                }
            }
            if (owner.extends_ != null) {
                T result = this.resolve(this.getExtClass(owner.extends_), name, memberType);
                if (result != null) {
                    return result;
                }
                for (String mixin : owner.mixins) {
                    result = this.resolve(this.getExtClass(mixin), name, memberType);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    public boolean isStatic(Member member) {
        return member.static_ || ExtJsApi.isConstantName(member.name);
    }

    private static boolean isConstantName(String name) {
        return CONSTANT_NAME_PATTERN.matcher(name).matches();
    }

    public boolean isReadOnly(Member member) {
        return member.readonly || ExtJsApi.isConstantName(member.name);
    }

    public boolean isProtected(Member member) {
        return "protected".equals(member.access);
    }

    public static boolean isPublicNonStaticMethodOrPropertyOrCfg(Member member) {
        return (member instanceof Method || member instanceof Property) && !member.static_ && !"private".equals(member.access) && !"protected".equals(member.access) && !"constructor".equals(member.name);
    }

    public static boolean isConst(Member member) {
        return member.readonly || member.name.equals(member.name.toUpperCase()) && member.value != null;
    }

    public ExtJsApi(String version, File srcFile) throws IOException {
        this.version = version;
        this.extClassByName = new HashMap<String, ExtClass>();
        this.extClasses = new LinkedHashSet<ExtClass>();
        Doxi doxi = ExtJsApi.readExtApiJson(srcFile);
        LinkedHashSet<ExtClass> overrides = new LinkedHashSet<ExtClass>();
        for (Tag tag : doxi.global.items) {
            if (!(tag instanceof ExtClass)) continue;
            ExtClass extClass = (ExtClass)tag;
            this.extClasses.add(extClass);
            if (extClass.override != null) {
                overrides.add(extClass);
                if (extClass.name.equals(extClass.override) && this.extClassByName.containsKey(extClass.name)) continue;
            }
            this.extClassByName.put(extClass.name, extClass);
            if (extClass.alternateClassNames == null) continue;
            for (String alternateClassName : extClass.alternateClassNames) {
                this.extClassByName.put(alternateClassName, extClass);
            }
        }
        for (ExtClass extClass : overrides) {
            ExtClass extClass2 = this.extClassByName.get(extClass.override);
            if (extClass2 == extClass) continue;
            if (extClass2 == null) {
                System.err.println("Overridden class not found: " + extClass.name + " wants to override " + extClass.override);
                continue;
            }
            extClass2.text = extClass2.text + "\n<p><b>From override " + extClass.name + ":</b></p>\n" + extClass.text;
            for (Members members : extClass.items) {
                List<Member> overriddenMembers = this.findOrCreateMembers(extClass2, members.$type);
                overriddenMembers.addAll(members.items);
            }
        }
        HashSet<ExtClass> collectMixins = new HashSet<ExtClass>();
        for (Tag tag : doxi.global.items) {
            if (!(tag instanceof ExtClass)) continue;
            ExtClass extClass = (ExtClass)tag;
            for (String mixin : extClass.mixins) {
                ExtClass mixinClass = this.getExtClass(mixin);
                if (mixinClass == null) continue;
                collectMixins.add(mixinClass);
            }
        }
        this.markTransitiveSupersAsMixins(collectMixins);
        this.mixins = Collections.unmodifiableSet(collectMixins);
    }

    public String getVersion() {
        return this.version;
    }

    private List<Member> findOrCreateMembers(ExtClass extClass, String memberType) {
        for (Members members : extClass.items) {
            if (!memberType.equals(members.$type)) continue;
            return members.items;
        }
        Members members = new Members();
        members.$type = memberType;
        extClass.items.add(members);
        return members.items;
    }

    private void markTransitiveSupersAsMixins(Set<ExtClass> extClasses) {
        Set<ExtClass> supers = this.supers(extClasses);
        while (!supers.isEmpty()) {
            extClasses.addAll(supers);
            supers = this.supers(supers);
        }
    }

    private Set<ExtClass> computeTransitiveSupersAndMixins(ExtClass extClass) {
        HashSet<ExtClass> result = new HashSet<ExtClass>();
        this.addTransitiveSupersAndMixins(result, extClass);
        return result;
    }

    private boolean addTransitiveSupersAndMixins(Set<ExtClass> supersAndMixins, ExtClass extClass) {
        if (extClass != null && supersAndMixins.add(extClass)) {
            this.addTransitiveSupersAndMixins(supersAndMixins, this.getSuperClass(extClass));
            for (String mixin : extClass.mixins) {
                this.addTransitiveSupersAndMixins(supersAndMixins, this.getExtClass(mixin));
            }
            return true;
        }
        return false;
    }

    private Set<ExtClass> supers(Set<ExtClass> extClasses) {
        HashSet<ExtClass> result = new HashSet<ExtClass>();
        for (ExtClass extClass : extClasses) {
            ExtClass superclass = this.getSuperClass(extClass);
            if (superclass == null) continue;
            result.add(superclass);
        }
        return result;
    }

    public Set<ExtClass> getExtClasses() {
        return this.extClasses;
    }

    public ExtClass getExtClass(String name) {
        return this.extClassByName.get(name);
    }

    public ExtClass getSuperClass(ExtClass extClass) {
        return this.getExtClass(extClass.extends_);
    }

    public Set<ExtClass> getMixins() {
        return this.mixins;
    }

    public static boolean isSingleton(ExtClass extClass) {
        return extClass != null && extClass.singleton;
    }

    private static class FixExtendsDeserializer
    extends JsonDeserializer<String> {
        private FixExtendsDeserializer() {
        }

        public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = (String)jsonParser.readValueAs(String.class);
            return Arrays.stream(value.split(",")).filter(className -> !"Object".equals(className)).findFirst().orElse("Object");
        }
    }

    private static class CommaSeparatedStringsDeserializer
    extends JsonDeserializer<List<String>> {
        private CommaSeparatedStringsDeserializer() {
        }

        public List<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String string = (String)jsonParser.readValueAs(String.class);
            return new ArrayList<String>(Arrays.asList(string.split(",")));
        }
    }

    public static class Event
    extends Member {
        public List<Var> items = Collections.emptyList();
        public boolean preventable;
    }

    @JsonIgnoreProperties(value={"disable", "fires", "removedMessage", "removedVersion"})
    public static class Method
    extends Member {
        public boolean template;
        public boolean constructor;
        public boolean chainable;
        @JsonProperty(value="abstract")
        public boolean abstract_;

        @Override
        public String toString() {
            return super.toString() + "(" + this.items.size() + ")";
        }
    }

    public static class Return
    extends Var {
    }

    public static class Param
    extends Var {
        public boolean optional;

        @JsonProperty(value="optional")
        public void setOptional(boolean value) {
            this.optional = value;
        }

        @JsonProperty(value="Optional")
        public void setUpperCaseOptional(boolean value) {
            this.optional = value;
        }
    }

    @JsonIgnoreProperties(value={"removedMessage", "removedVersion"})
    public static class Property
    extends Member {
        public boolean required;
        public boolean optional;
        public boolean controllable;
        public boolean dynamic;
    }

    @JsonIgnoreProperties(value={"aliasPrefix", "items"})
    public static class Enum
    extends Tag {
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=Method.class, name="method"), @JsonSubTypes.Type(value=Property.class, name="property"), @JsonSubTypes.Type(value=Event.class, name="event")})
    public static class Member
    extends Var {
        @JsonProperty(value="static")
        public boolean static_;
        public boolean inheritable;
        public Object accessor;
        public boolean evented;
        public boolean readonly;
        public boolean hide;
        public boolean ignore;
        public boolean undocumented;
        public boolean locale;
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=Param.class, name="param"), @JsonSubTypes.Type(value=Return.class, name="return"), @JsonSubTypes.Type(value=Method.class, name="method"), @JsonSubTypes.Type(value=Property.class, name="property"), @JsonSubTypes.Type(value=Event.class, name="event")})
    public static abstract class Var
    extends Tag {
        public String type = "";
        public String value;
        public List<Var> items = Collections.emptyList();
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=Members.class, name="methods"), @JsonSubTypes.Type(value=Members.class, name="static-methods"), @JsonSubTypes.Type(value=Members.class, name="properties"), @JsonSubTypes.Type(value=Members.class, name="static-properties"), @JsonSubTypes.Type(value=Members.class, name="configs"), @JsonSubTypes.Type(value=Members.class, name="vars"), @JsonSubTypes.Type(value=Members.class, name="events"), @JsonSubTypes.Type(value=Members.class, name="sass-mixins")})
    private static class Members
    extends Tag {
        private List<Member> items;

        private Members() {
        }

        public void setItems(List<Member> items) {
            if ("configs".equals(this.$type)) {
                for (Member item : items) {
                    item.$type = "cfg";
                }
            }
            this.items = new ArrayList<Member>(items.size());
            HashMap<String, Member> itemByName = new HashMap<String, Member>();
            for (Member member : items) {
                String key = member.static_ + "-" + member.name;
                Member oldMember = (Member)itemByName.get(key);
                if (oldMember != null) {
                    System.out.println("merging " + oldMember + " and " + member);
                    if (oldMember.text.isEmpty()) {
                        oldMember.text = member.text;
                    }
                    if (this.countNonPrivateItems(oldMember.items) >= this.countNonPrivateItems(member.items)) continue;
                    oldMember.items = member.items;
                    continue;
                }
                itemByName.put(key, member);
                this.items.add(member);
            }
            this.items = items;
        }

        private long countNonPrivateItems(List<? extends Tag> items) {
            return items.stream().filter(item -> !"private".equals(item.access)).count();
        }
    }

    @JsonIgnoreProperties(value={"extended", "extenders", "package", "mixed", "mixers", "requires", "uses", "abstract", "Classic", "CT_Location", "disable"})
    public static class ExtClass
    extends Tag {
        @JsonProperty(value="extends")
        @JsonDeserialize(using=FixExtendsDeserializer.class)
        public String extends_;
        @JsonDeserialize(using=CommaSeparatedStringsDeserializer.class)
        public List<String> mixins = Collections.emptyList();
        public String override;
        @JsonDeserialize(using=CommaSeparatedStringsDeserializer.class)
        public List<String> alternateClassNames;
        public String alias;
        public boolean singleton;
        public List<Members> items = Collections.emptyList();
    }

    @JsonTypeName(value="namespace")
    private static class Namespace
    extends Tag {
        public List<? extends Tag> items;

        private Namespace() {
        }
    }

    @JsonTypeName(value="doxi")
    @JsonIgnoreProperties(value={"files", "version"})
    private static class Doxi
    extends Tag {
        public Namespace global;

        private Doxi() {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="$type", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ExtClass.class, name="class"), @JsonSubTypes.Type(value=Enum.class, name="enum"), @JsonSubTypes.Type(value=Member.class, name="member")})
    public static class Tag {
        public String $type;
        public String name;
        public String since;
        public boolean deprecated;
        public String deprecatedMessage;
        public String deprecatedVersion;
        public String text = "";
        public String inheritdoc;
        public String localdoc;
        public String access;
        public Object src;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.name.equals(tag.name) && !(this.$type == null ? tag.$type != null : !this.$type.equals(tag.$type));
        }

        public int hashCode() {
            int result = this.$type != null ? this.$type.hashCode() : 0;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return (this.access != null ? this.access + " " : "") + this.$type + " " + this.name;
        }
    }
}

