/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.apprunner.proxy;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jangaroo.apprunner.proxy.HttpClientUtil;
import net.jangaroo.apprunner.util.DynamicPackagesDeSerializer;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;

public class AddDynamicPackagesServlet
extends HttpServlet {
    private final String url;
    private final List<String> senchaPackageNames;

    public AddDynamicPackagesServlet(String url, List<String> senchaPackageNames) {
        this.url = url;
        this.senchaPackageNames = senchaPackageNames;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LinkedHashSet<String> dynamicPackages;
        try {
            CloseableHttpResponse httpResponse = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientUtil.createSSLSocketFactory()).build().execute((HttpUriRequest)new HttpGet(this.url));
            dynamicPackages = new LinkedHashSet<String>(DynamicPackagesDeSerializer.readDynamicPackages(httpResponse.getEntity().getContent()));
            dynamicPackages.addAll(this.senchaPackageNames);
        }
        catch (IOException e) {
            dynamicPackages = new LinkedHashSet<String>(this.senchaPackageNames);
        }
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
        resp.setHeader("Content-Type", "application/json");
        DynamicPackagesDeSerializer.writeDynamicPackages((OutputStream)resp.getOutputStream(), dynamicPackages);
    }
}

