/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.apprunner.proxy;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalPackagesFromFolderServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PACKAGES = "packages";
    private static final String PACKAGES_PATH_INFO = "/packages/";
    private final File[] additionalPackagesDirectories;

    public AdditionalPackagesFromFolderServlet(File[] additionalPackagesDirectories) {
        this.additionalPackagesDirectories = additionalPackagesDirectories;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SequencedCollection<Object> additionalPackages;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || "/".equals(pathInfo)) {
            additionalPackages = this.additionalPackagesDirectories == null ? Collections.emptyList() : Collections.singletonList(PACKAGES);
        } else if (PACKAGES_PATH_INFO.equals(pathInfo)) {
            additionalPackages = new LinkedHashSet();
            for (File additionalPackagesDirectory : this.additionalPackagesDirectories) {
                File directoryToList = new File(additionalPackagesDirectory, PACKAGES);
                List<String> subdirectoryNames = AdditionalPackagesFromFolderServlet.getSubdirectoryNames(directoryToList);
                if (subdirectoryNames == null) {
                    LOG.warn("Directory " + directoryToList.getAbsolutePath() + " could not be listed, please check paths configured as 'additionalPackagesDirs'.");
                    continue;
                }
                additionalPackages.addAll(subdirectoryNames);
            }
        } else {
            resp.sendError(404);
            return;
        }
        List nginxAutoIndexJson = additionalPackages.stream().map(AdditionalPackagesFromFolderServlet::createNginxAutoIndexJsonEntry).collect(Collectors.toList());
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
        resp.setHeader("Content-Type", "application/json");
        new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)new PrintWriter((OutputStream)resp.getOutputStream()), nginxAutoIndexJson);
    }

    private static List<String> getSubdirectoryNames(File directoryToList) {
        try {
            File[] subdirs = directoryToList.listFiles(File::isDirectory);
            if (subdirs != null) {
                return Arrays.stream(subdirs).map(File::getName).collect(Collectors.toList());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static Map<String, String> createNginxAutoIndexJsonEntry(String packageName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("name", packageName);
        result.put("type", "directory");
        return result;
    }
}

