/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.apprunner.proxy;

import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jangaroo.apprunner.proxy.HttpClientUtil;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.dsmiley.httpproxy.ProxyServlet;

public class JangarooProxyServlet
extends ProxyServlet {
    protected String rewritePathInfoFromRequest(HttpServletRequest servletRequest) {
        String requestURI = servletRequest.getRequestURI();
        try {
            requestURI = URLDecoder.decode(requestURI, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding.", e);
        }
        String servletPath = servletRequest.getServletPath();
        assert (requestURI.startsWith(servletPath)) : "Unexpected state: request Uri " + servletRequest.getRequestURI() + " does not start with servlet path " + servletRequest.getServletPath();
        return requestURI.substring(servletPath.length());
    }

    protected HttpClient createHttpClient() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(this.buildRequestConfig()).setDefaultSocketConfig(this.buildSocketConfig());
        clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientUtil.createSSLSocketFactory());
        clientBuilder.setMaxConnTotal(this.maxConnections);
        if (this.useSystemProperties) {
            clientBuilder.useSystemProperties();
        }
        return clientBuilder.build();
    }

    protected void copyProxyCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String headerValue) {
        String path = servletRequest.getContextPath();
        if ((path = path + servletRequest.getServletPath()).isEmpty()) {
            path = "/";
        }
        for (HttpCookie cookie : HttpCookie.parse(headerValue)) {
            String proxyCookieName = this.doPreserveCookies ? cookie.getName() : this.getCookieNamePrefix(cookie.getName()) + cookie.getName();
            Cookie servletCookie = new Cookie(proxyCookieName, cookie.getValue());
            servletCookie.setComment(cookie.getComment());
            servletCookie.setMaxAge((int)cookie.getMaxAge());
            servletCookie.setPath(path);
            servletCookie.setSecure(JangarooProxyServlet.applyCookieSecurePatch(servletRequest, cookie));
            servletCookie.setVersion(cookie.getVersion());
            servletCookie.setHttpOnly(cookie.isHttpOnly());
            servletResponse.addCookie(servletCookie);
        }
    }

    private static boolean applyCookieSecurePatch(HttpServletRequest servletRequest, HttpCookie cookie) {
        return "https".equals(servletRequest.getScheme()) && cookie.getSecure();
    }
}

