/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.apprunner.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppsDeSerializer {
    private static final String PATH_PROPERTY = "path";
    private static final String PATHS_PROPERTY = "paths";
    private static final String CSS_PROPERTY = "css";
    private static final String JS_PROPERTY = "js";
    private static final String LOAD_ORDER_PROPERTY = "loadOrder";

    public static List<AppInfo> readApps(InputStream appsSource, Path rootPath) throws IOException {
        List appMaps = (List)new ObjectMapper().readValue(appsSource, List.class);
        return appMaps.stream().map(appMap -> new AppInfo((String)appMap.get("name"), rootPath.resolve((String)appMap.get(PATH_PROPERTY)), (List)appMap.get("locales"))).collect(Collectors.toList());
    }

    public static void writeApps(OutputStream output, Path rootPath, List<AppInfo> apps) throws IOException {
        new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)new PrintWriter(output), apps.stream().map(appInfo -> {
            HashMap<String, Object> appMap = new HashMap<String, Object>();
            appMap.put("name", appInfo.name);
            appMap.put(PATH_PROPERTY, rootPath.relativize(appInfo.path).toString().replace('\\', '/'));
            appMap.put("locales", appInfo.locales);
            return appMap;
        }).collect(Collectors.toList()));
    }

    public static void rewriteBootstrapJsonPaths(InputStream bootstrapJsonSource, OutputStream bootstrapJsonTarget, Map<String, String> pathMapping) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map bootstrap = (Map)objectMapper.readValue(bootstrapJsonSource, Map.class);
        Map classToPath = (Map)bootstrap.get(PATHS_PROPERTY);
        classToPath.forEach((key, value) -> classToPath.put(key, AppsDeSerializer.rewritePath(value, pathMapping)));
        Arrays.asList(CSS_PROPERTY, JS_PROPERTY, LOAD_ORDER_PROPERTY).forEach(propertyWithPathObjectList -> {
            if (bootstrap.containsKey(propertyWithPathObjectList)) {
                List pathObjectList = (List)bootstrap.get(propertyWithPathObjectList);
                pathObjectList.forEach(pathObject -> {
                    if (pathObject.containsKey(PATH_PROPERTY)) {
                        pathObject.put(PATH_PROPERTY, AppsDeSerializer.rewritePath((String)pathObject.get(PATH_PROPERTY), pathMapping));
                    }
                });
            }
        });
        objectMapper.writeValue((Writer)new PrintWriter(bootstrapJsonTarget), (Object)bootstrap);
    }

    private static String rewritePath(String path, Map<String, String> pathMappings) {
        for (String oldPath : pathMappings.keySet()) {
            if (!path.startsWith(oldPath)) continue;
            String newPath = pathMappings.get(oldPath);
            path = newPath + path.substring(oldPath.length());
        }
        return path;
    }

    public static class AppInfo {
        public final String name;
        public final Path path;
        public final List<String> locales;

        public AppInfo(String name, Path path, List<String> locales) {
            this.name = name;
            this.path = path;
            this.locales = locales;
        }
    }
}

