/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.apprunner.util;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import net.jangaroo.apprunner.proxy.JangarooProxyServlet;
import net.jangaroo.apprunner.util.AllowSymLinkAliasChecker;
import net.jangaroo.apprunner.util.ProxyServletConfig;
import net.jangaroo.apprunner.util.StaticResourcesServletConfig;
import org.apache.commons.lang3.Range;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWrapper {
    private static final long WAIT_TIME_MILLIS = 1000L;
    private static final int RANDOM_PORT_RETRY_LIMIT = 20;
    private static final Integer RANDOM_PORT_IDENTIFIER = 0;
    public static final String ROOT_PATH = "/";
    public static final String ROOT_PATH_SPEC = "/*";
    private static final StaticResourcesServletConfig DEFAULT_RESOURCES_SERVLET_CONFIG = new StaticResourcesServletConfig("/*", "/");
    private static final Logger LOG;
    private final Map<String, Configuration> configurationByPath = new HashMap<String, Configuration>();
    private Server server;
    private Class<? extends WebAppContext> webAppContextClass = WebAppContext.class;

    public JettyWrapper(Path ... baseDirs) {
        this.addBaseDirs(baseDirs);
    }

    public void addBaseDir(Path baseDir) {
        this.addBaseDir(baseDir, ROOT_PATH);
    }

    public void addBaseDirs(Path ... baseDirs) {
        Collections.addAll(this.getConfiguration(ROOT_PATH).baseDirs, baseDirs);
    }

    public void setWebAppContextClass(Class<? extends WebAppContext> webAppContextClass) {
        this.webAppContextClass = webAppContextClass;
    }

    public void addBaseDir(Path baseDir, String path) {
        this.getConfiguration(path).addBaseDir(baseDir);
    }

    public void addResourceJar(File resourceJar) {
        this.addResourceJar(resourceJar, ROOT_PATH);
    }

    public void addResourceJar(File resourceJar, String path) {
        this.addBaseDirInResourceJar(resourceJar, "META-INF/resources", path);
    }

    public void addBaseDirInResourceJar(File resourceJar, String relativePathInsideJar) {
        this.addBaseDirInResourceJar(resourceJar, relativePathInsideJar, ROOT_PATH);
    }

    public void addBaseDirInResourceJar(File resourceJar, String relativePathInsideJar, String path) {
        this.getConfiguration(path).addResourceJar(new JarFileWithRelativePath(resourceJar, relativePathInsideJar));
    }

    public void setStaticResourcesServletConfigs(List<StaticResourcesServletConfig> staticResourcesServletConfigs) {
        this.setStaticResourcesServletConfigs(staticResourcesServletConfigs, ROOT_PATH);
    }

    public void setStaticResourcesServletConfigs(List<StaticResourcesServletConfig> staticResourcesServletConfigs, String path) {
        this.getConfiguration(path).setStaticResourcesServletConfigs(staticResourcesServletConfigs);
    }

    public void setProxyServletConfigs(List<ProxyServletConfig> proxyServletConfigs) {
        this.setProxyServletConfigs(proxyServletConfigs, ROOT_PATH);
    }

    public void setProxyServletConfigs(List<ProxyServletConfig> proxyServletConfigs, String path) {
        this.getConfiguration(path).setProxyServletConfigs(proxyServletConfigs);
    }

    public void setAdditionalServlets(Map<String, Servlet> additionalServlets) {
        this.setAdditionalServlets(additionalServlets, ROOT_PATH);
    }

    public void setAdditionalServlets(Map<String, Servlet> additionalServlets, String path) {
        for (Map.Entry<String, Servlet> servletEntry : additionalServlets.entrySet()) {
            this.getLog().info(String.format("  Servlet: %s -> %s", JettyWrapper.resolve(path, servletEntry.getKey()), servletEntry.getValue().getClass().getSimpleName()));
        }
        this.getConfiguration(path).setAdditionalServlets(additionalServlets);
    }

    public void start(String host, int port) throws JettyWrapperException {
        this.start(host, (Range<Integer>)Range.is((Comparable)Integer.valueOf(port)));
    }

    public void start(String host, Range<Integer> portRange) throws JettyWrapperException {
        if (this.server != null) {
            this.stop();
        }
        Exception lastException = null;
        HandlerCollection handlerCollection = new HandlerCollection();
        ArrayList<String> paths = new ArrayList<String>(this.configurationByPath.keySet());
        paths.sort((path1, path2) -> {
            String[] dirs1 = path1.split(ROOT_PATH);
            String[] dirs2 = path2.split(ROOT_PATH);
            return dirs2.length - dirs1.length;
        });
        for (String path : paths) {
            Configuration configuration = this.getConfiguration(path);
            WebAppContext handler = this.createHandler(path, configuration.baseDirs, configuration.jarFilesWithRelativePath, configuration.staticResourcesServletConfigs, configuration.proxyServletConfigs, configuration.additionalServlets);
            handlerCollection.addHandler((Handler)handler);
        }
        List<Integer> shuffledPorts = this.shufflePortRange(portRange);
        for (Integer port : shuffledPorts) {
            try {
                this.tryServerStart(host, port, (Handler)handlerCollection);
                break;
            }
            catch (Exception e) {
                this.getLog().debug("Could not start server", (Throwable)e);
                lastException = e;
            }
        }
        if (this.server == null || !this.server.isRunning()) {
            throw new JettyWrapperException("Could not start server", lastException);
        }
    }

    private void tryServerStart(String host, Integer port, Handler handler) throws Exception {
        int retryLimit = RANDOM_PORT_IDENTIFIER.equals(port) ? 20 : 1;
        Exception lastException = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                this.server = null;
                this.server = this.createServer(host, port, handler);
                this.server.start();
                break;
            }
            catch (Exception e) {
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                this.getLog().warn("Could not stop server", (Throwable)e);
            }
        }
    }

    public URI getUri() {
        return this.server.getURI().resolve(ROOT_PATH);
    }

    public void waitUntilStarted(int timeoutMillis) throws JettyWrapperException {
        if (this.server == null) {
            throw new JettyWrapperException("Server not started");
        }
        this.getLog().info(String.format("Waiting for Server startup (timeout = %d ms)", timeoutMillis));
        int waitedMillis = 0;
        try {
            while (waitedMillis < timeoutMillis && !this.server.isStarted()) {
                this.getLog().debug("Server not ready yet. Waiting ...");
                Thread.sleep(1000L);
                waitedMillis = (int)((long)waitedMillis + 1000L);
            }
        }
        catch (InterruptedException e) {
            this.getLog().warn("Interrupted while waiting for startup", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.server.isStarted()) {
            throw new JettyWrapperException(String.format("Server did not start within %d ms", timeoutMillis));
        }
    }

    public void blockUntilInterrupted() {
        try {
            this.server.join();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    private Configuration getConfiguration(String path) {
        if (path.contains("\\")) {
            this.getLog().warn("Path should not contain backslashes: " + path);
        }
        if (!this.configurationByPath.containsKey(path)) {
            this.configurationByPath.put(path, new Configuration());
        }
        return this.configurationByPath.get(path);
    }

    private Server createServer(String host, int port, Handler handler) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.getLog().info("Creating Jetty server at " + address);
        Server server = new Server(address);
        server.setHandler(handler);
        return server;
    }

    private WebAppContext createHandler(String path, List<Path> baseDirs, List<JarFileWithRelativePath> resourceJarsWithRelativePaths, List<StaticResourcesServletConfig> staticResourcesServletConfigs, List<ProxyServletConfig> proxyServletConfigs, Map<String, Servlet> additionalServlets) throws JettyWrapperException {
        boolean hasRootPathServlet = !ROOT_PATH.equals(path);
        try {
            this.getLog().info("Setting up handler with context path " + path);
            WebAppContext handler = this.webAppContextClass.newInstance();
            handler.setContextPath(path);
            handler.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            List baseResources = baseDirs.stream().map(Resource::newResource).collect(Collectors.toList());
            baseResources = new ArrayList(baseResources);
            if (!resourceJarsWithRelativePaths.isEmpty()) {
                baseResources.addAll(resourceJarsWithRelativePaths.stream().map(JarFileWithRelativePath::toResource).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            handler.setBaseResource((Resource)new ResourceCollection((Resource[])baseResources.stream().filter(Resource::exists).toArray(Resource[]::new)));
            this.getLog().info("  Using base resources: " + baseResources);
            if (staticResourcesServletConfigs != null && !staticResourcesServletConfigs.isEmpty()) {
                for (StaticResourcesServletConfig staticResourcesServletConfig : staticResourcesServletConfigs) {
                    hasRootPathServlet = this.addDefaultServlet((ServletContextHandler)handler, staticResourcesServletConfig) || hasRootPathServlet;
                }
            }
            if (proxyServletConfigs != null && !proxyServletConfigs.isEmpty()) {
                for (ProxyServletConfig proxyServletConfig : proxyServletConfigs) {
                    hasRootPathServlet = this.addProxyServlet((ServletContextHandler)handler, proxyServletConfig) || hasRootPathServlet;
                }
            }
            if (additionalServlets != null && !additionalServlets.isEmpty()) {
                for (Map.Entry entry : additionalServlets.entrySet()) {
                    hasRootPathServlet = this.addServlet((ServletContextHandler)handler, new ServletHolder((Servlet)entry.getValue()), (String)entry.getKey()) || hasRootPathServlet;
                }
            }
            if (!hasRootPathServlet) {
                this.addDefaultServlet((ServletContextHandler)handler, DEFAULT_RESOURCES_SERVLET_CONFIG);
            }
            return handler;
        }
        catch (Exception e) {
            throw new JettyWrapperException(e);
        }
    }

    private boolean addDefaultServlet(ServletContextHandler webAppContext, StaticResourcesServletConfig config) {
        String pathSpec = config.getPathSpec();
        ServletHolder servletHolder = new ServletHolder(DefaultServlet.class);
        servletHolder.setInitParameter("relativeResourceBase", config.getRelativeResourceBase());
        servletHolder.setInitParameter("cacheControl", "no-store, no-cache, must-revalidate, max-age=0");
        webAppContext.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        boolean addedRootPathServlet = this.addServlet(webAppContext, servletHolder, pathSpec);
        this.getLog().info(String.format("  Serving static resources: %s -> %s", JettyWrapper.resolve(webAppContext.getContextPath(), pathSpec), config.getRelativeResourceBase()));
        return addedRootPathServlet;
    }

    private boolean addProxyServlet(ServletContextHandler webAppContext, ProxyServletConfig config) {
        String pathSpec = config.getPathSpec();
        ServletHolder servletHolder = new ServletHolder(pathSpec, JangarooProxyServlet.class);
        servletHolder.setInitParameter("targetUri", config.getTargetUri().replaceAll("/$", ""));
        servletHolder.setInitParameter("forwardip", String.valueOf(config.isForwardedHeaderEnabled()));
        servletHolder.setInitParameter("log", String.valueOf(config.isLoggingEnabled()));
        servletHolder.setInitParameter("preserveCookies", "true");
        boolean addedRootPathServlet = this.addServlet(webAppContext, servletHolder, pathSpec);
        this.getLog().info(String.format("  Proxying requests: %s -> %s", JettyWrapper.resolve(webAppContext.getContextPath(), pathSpec), config.getTargetUri()));
        return addedRootPathServlet;
    }

    private boolean addServlet(ServletContextHandler webAppContext, ServletHolder servletHolder, String pathSpec) {
        webAppContext.addServlet(servletHolder, pathSpec);
        return ROOT_PATH_SPEC.equals(pathSpec);
    }

    private List<Integer> shufflePortRange(Range<Integer> portRange) {
        ArrayList<Integer> shuffledPorts = new ArrayList<Integer>();
        for (int i = ((Integer)portRange.getMinimum()).intValue(); i <= (Integer)portRange.getMaximum(); ++i) {
            shuffledPorts.add(i);
        }
        Collections.shuffle(shuffledPorts);
        return shuffledPorts;
    }

    protected Logger getLog() {
        return LOG;
    }

    private static String resolve(String base, String relative) {
        return (ROOT_PATH.equals(base) ? "" : base) + relative;
    }

    static {
        Resource.setDefaultUseCaches((boolean)false);
        LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    private static class Configuration {
        private final List<Path> baseDirs = new ArrayList<Path>();
        private final List<JarFileWithRelativePath> jarFilesWithRelativePath = new ArrayList<JarFileWithRelativePath>();
        private List<StaticResourcesServletConfig> staticResourcesServletConfigs;
        private List<ProxyServletConfig> proxyServletConfigs;
        private Map<String, Servlet> additionalServlets;

        private Configuration() {
        }

        public void addBaseDir(Path baseDir) {
            this.baseDirs.add(baseDir);
        }

        public void addBaseDirs(Path ... baseDirs) {
            Collections.addAll(this.baseDirs, baseDirs);
        }

        public void setStaticResourcesServletConfigs(List<StaticResourcesServletConfig> staticResourcesServletConfigs) {
            this.staticResourcesServletConfigs = staticResourcesServletConfigs;
        }

        public void addResourceJar(JarFileWithRelativePath jarFileWithRelativePath) {
            this.jarFilesWithRelativePath.add(jarFileWithRelativePath);
        }

        public void setProxyServletConfigs(List<ProxyServletConfig> proxyServletConfigs) {
            this.proxyServletConfigs = proxyServletConfigs;
        }

        public void setAdditionalServlets(Map<String, Servlet> additionalServlets) {
            this.additionalServlets = additionalServlets;
        }
    }

    private static class JarFileWithRelativePath {
        public final File jarFile;
        public final String relativePath;

        private JarFileWithRelativePath(File jarFile, String relativePath) {
            this.jarFile = jarFile;
            this.relativePath = relativePath;
        }

        public Resource toResource() {
            try {
                return Resource.newResource((String)("jar:" + Resource.toURL((File)this.jarFile).toString() + "!/" + this.relativePath));
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static final class JettyWrapperException
    extends Exception {
        JettyWrapperException(String message) {
            super(message);
        }

        JettyWrapperException(String message, Throwable cause) {
            super(message, cause);
        }

        JettyWrapperException(Throwable cause) {
            super(cause);
        }
    }
}

