/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.apprunner.util;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import net.jangaroo.apprunner.util.Junctions;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowSymLinkAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean check(String uri, Resource resource) {
        block6: {
            if (!(resource instanceof PathResource)) {
                return false;
            }
            PathResource pathResource = (PathResource)resource;
            try {
                Path path = pathResource.getPath();
                Path alias = pathResource.getAliasPath();
                if (path.equals(alias)) {
                    return false;
                }
                if (this.hasSymbolicLink(path) && Files.isSameFile(path, alias)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Allow symlink {} --> {}", (Object)resource, (Object)pathResource.getAliasPath());
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Symlink check for " + uri + " failed.", (Throwable)e);
            }
        }
        return false;
    }

    private boolean hasSymbolicLink(Path path) {
        if (Junctions.isSymbolicLink(path)) {
            return true;
        }
        Path base = path.getRoot();
        for (Path segment : path) {
            if (!Junctions.isSymbolicLink(base = base.resolve(segment))) continue;
            return true;
        }
        return false;
    }
}

