package js{
public interface CanvasRenderingContext2D {

  // back-reference to the canvas
  native function get canvas() : HTMLCanvasElement;

  // state
  native function save() : void; // push state on state stack
  native function restore() : void; // pop state stack and restore state

  // transformations (default transform is the identity matrix)
  native function scale(x : Number, y : Number) : void;

  native function rotate(angle : Number) : void;

  native function translate(x : Number, y : Number) : void;

  native function transform(m11 : Number, m12 : Number, m21 : Number, m22 : Number, dx : Number, dy : Number) : void;

  native function setTransform(m11 : Number, m12 : Number, m21 : Number, m22 : Number, dx : Number, dy : Number) : void;

  // compositing
  native function get globalAlpha() : Number; // (default 1.0)
  native function set globalAlpha(alpha : Number) : void;

  native function get globalCompositeOperation() : String; // (default source-over)
  native function set globalCompositeOperation(op : String) : void;

  // colors and styles
  native function get strokeStyle() : *; // (default black)
  native function set strokeStyle(style : *) : void;

  native function get fillStyle() : *; // (default black)
  native function set fillStyle(style : *) : void;

  native function createLinearGradient(x0 : Number, y0 : Number, x1 : Number, y1 : Number) : CanvasGradient;

  native function createRadialGradient(x0 : Number, y0 : Number, r0 : Number, x1 : Number, y1 : Number, r1 : Number) : CanvasGradient;

  /**
   * @param image HTMLImageElement, HTMLCanvasElement, or HTMLVideoElement.
   * @param repetition
   * @return
   */
  native function createPattern(image : HTMLElement, repetition : String) : CanvasPattern;

  // line caps/joins
  native function get lineWidth() : Number; // (default 1)
  native function set lineWidth(width : Number) : void;

  native function get lineCap() : String; // "butt", "round", "square" (default "butt")
  native function set lineCap(cap : String) : void; // "butt", "round", "square" (default "butt")
  native function get lineJoin() : String; // "round", "bevel", "miter" (default "miter")
  native function set lineJoin(join : String) : void; // "round", "bevel", "miter" (default "miter")
  native function get miterLimit() : Number; // (default 10)
  native function set miterLimit(limit : Number) : void; // (default 10)

  // shadows
  native function get shadowOffsetX() : Number; // (default 0)
  native function set shadowOffsetX(x : Number) : void;

  native function get shadowOffsetY() : Number; // (default 0)
  native function set shadowOffsetY(y : Number) : void;

  native function get shadowBlur() : Number; // (default 0)
  native function set shadowBlur(blur : Number) : void;

  native function get shadowColor() : String; // (default transparent black)
  native function set shadowColor(color : String) : void;

  // rects
  native function clearRect(x : Number, y : Number, w : Number, h : Number) : void;

  native function fillRect(x : Number, y : Number, w : Number, h : Number) : void;

  native function strokeRect(x : Number, y : Number, w : Number, h : Number) : void;

  // path API
  native function beginPath() : void;

  native function closePath() : void;

  native function moveTo(x : Number, y : Number) : void;

  native function lineTo(x : Number, y : Number) : void;

  native function quadraticCurveTo(cpx : Number, cpy : Number, x : Number, y : Number) : void;

  native function bezierCurveTo(cp1x : Number, cp1y : Number, cp2x : Number, cp2y : Number, x : Number, y : Number) : void;

  native function arcTo(x1 : Number, y1 : Number, x2 : Number, y2 : Number, radius : Number) : void;

  native function rect(x : Number, y : Number, w : Number, h : Number) : void;

  native function arc(x : Number, y : Number, radius : Number, startAngle : Number, endAngle : Number, anticlockwise : Boolean) : void;

  native function fill() : void;

  native function stroke() : void;

  native function clip() : void;

  native function isPointInPath(x : Number, y : Number) : Boolean;

  // text
  native function get font() : String; // (default 10px sans-serif)
  native function set font(font : String) : void;

  native function get textAlign() : String; // "start", "end", "left", "right", "center" (default: "start")
  native function set textAlign(align : String) : void;

  native function get textBaseline() : String; // "top", "hanging", "middle", "alphabetic", "ideographic", "bottom" (default: "alphabetic")
  native function set textBaseline(baseline : String) : void;

  native function fillText(text : String, x : Number, y : Number, maxWidth : Number = undefined) : void;

  native function strokeText(text : String, x : Number, y : Number, maxWidth : Number = undefined) : void;

  native function measureText(text : String) : TextMetrics;

  /**
   * To draw images onto the canvas, the drawImage method can be used.
   * This method can be invoked with three different sets of arguments:
   * drawImage(image, dx, dy)
   * drawImage(image, dx, dy, dw, dh)
   * drawImage(image, sx, sy, sw, sh, dx, dy, dw, dh)
   * @param image HTMLImageElement, HTMLCanvasElement, or HTMLVideoElement.
   */
  native function drawImage(image : HTMLElement, dxOrSx : Number, dyOrSy : Number,
                     dwOrSw : Number = undefined, dhOrSh : Number = undefined,
                     dx : Number = undefined, dy : Number = undefined,
                     dw : Number = undefined, dh : Number = undefined) : void;

  /**
   *   pixel manipulation
   * @param imagedataOrSw - ImageData or Number
   * @param sh
   * @return
   */
  native function createImageData(imagedataOrSw : *, sh : Number) : ImageData;

  native function getImageData(sx : Number, sy : Number, sw : Number, sh : Number) : ImageData;

  native function putImageData(imagedata : ImageData, dx : Number, dy : Number, dirtyX : Number = undefined, dirtyY : Number = undefined, dirtyWidth : Number = undefined, dirtyHeight : Number = undefined) : void;

}
}