/* The following code was generated by JFlex 1.4.3 on 11/16/10 2:19 PM */

/*
 * Copyright 2008-2010 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/*
 * JangarooScript lexical scanner definition for the JFlex scanner generator
 *
 * Author: Andreas Gawecki
 */

/*
From http://livedocs.adobe.com/specs/actionscript/3/as3_specification118.html:

13.1 Lexical

Lexical keywords are removed from the available program namespace during scanning. It is a syntax error to use any of
these names except as indicated by the grammar. Syntactic keywords appear to the lexical scanner as identifier tokens,
but are given special meaning in certain contexts by the parser.

The following list contains all keywords:

as break case catch class const continue default delete do else extends false finally for function if implements import
in instanceof interface internal is new null package private protected public return super switch this throw
true try typeof use var void while with

The following list contains all identifiers that are syntactic keywords:

each get set to namespace include dynamic final native override static

Former Jangaroo keywords:

abstract assert enum final goto namespace override static synchronized throws transient volatile


13.2 Syntactic

Identifiers with special meaning become keywords in certain syntactic contexts:

    * In a for-each-in statement between the 'for' token and the '(' token:
      each
    * In a function definition between the 'function' token and an identifier token:
      get set
    * As the first word of a directive:
      namespace include
    * In an attribute list or wherever an attribute list can be used:
      dynamic final native override static

It is a syntax error to use a syntactic keyword in a context where it is treated as a keyword:

namespace = "hello"
namespace()

In these cases, the grammar requires an identifier after the namespace keyword.


*/

package net.jangaroo.jooc;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 11/16/10 2:19 PM from the specification file
 * <tt>/home/mohlendo/gitorious/jangaroo-tools/target/checkout/jangaroo-core/jangaroo-compiler/src/main/jflex/net/jangaroo/jooc/joo.flex</tt>
 */
class Scanner extends ScannerBase implements sym, java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING_DQ = 4;
  public static final int REGEXP_REST = 10;
  public static final int YYINITIAL = 0;
  public static final int REGEXP_FIRST = 8;
  public static final int REGEXP_START = 6;
  public static final int STRING_SQ = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\75\1\0\1\3\1\2\22\0\1\31\1\63\1\32"+
    "\1\0\1\6\1\72\1\66\1\74\1\52\1\53\1\5\1\70\1\57"+
    "\1\15\1\13\1\4\1\10\11\11\1\65\1\56\1\62\1\60\1\61"+
    "\1\64\1\6\4\21\1\14\1\21\24\6\1\16\1\17\1\20\1\71"+
    "\1\6\1\0\1\33\1\35\1\24\1\27\1\30\1\43\1\50\1\41"+
    "\1\22\1\6\1\37\1\25\1\45\1\23\1\42\1\46\1\6\1\36"+
    "\1\34\1\40\1\26\1\51\1\47\1\12\1\44\1\6\1\54\1\67"+
    "\1\55\1\73\53\0\1\6\12\0\1\6\4\0\1\6\5\0\27\6"+
    "\1\0\37\6\1\0\u013f\6\31\0\162\6\4\0\14\6\16\0\5\6"+
    "\11\0\1\6\213\0\1\6\13\0\1\6\1\0\3\6\1\0\1\6"+
    "\1\0\24\6\1\0\54\6\1\0\46\6\1\0\5\6\4\0\202\6"+
    "\10\0\105\6\1\0\46\6\2\0\2\6\6\0\20\6\41\0\46\6"+
    "\2\0\1\6\7\0\47\6\110\0\33\6\5\0\3\6\56\0\32\6"+
    "\5\0\13\6\25\0\12\7\4\0\2\6\1\0\143\6\1\0\1\6"+
    "\17\0\2\6\7\0\2\6\12\7\3\6\2\0\1\6\20\0\1\6"+
    "\1\0\36\6\35\0\3\6\60\0\46\6\13\0\1\6\u0152\0\66\6"+
    "\3\0\1\6\22\0\1\6\7\0\12\6\4\0\12\7\25\0\10\6"+
    "\2\0\2\6\2\0\26\6\1\0\7\6\1\0\1\6\3\0\4\6"+
    "\3\0\1\6\36\0\2\6\1\0\3\6\4\0\12\7\2\6\23\0"+
    "\6\6\4\0\2\6\2\0\26\6\1\0\7\6\1\0\2\6\1\0"+
    "\2\6\1\0\2\6\37\0\4\6\1\0\1\6\7\0\12\7\2\0"+
    "\3\6\20\0\11\6\1\0\3\6\1\0\26\6\1\0\7\6\1\0"+
    "\2\6\1\0\5\6\3\0\1\6\22\0\1\6\17\0\2\6\4\0"+
    "\12\7\25\0\10\6\2\0\2\6\2\0\26\6\1\0\7\6\1\0"+
    "\2\6\1\0\5\6\3\0\1\6\36\0\2\6\1\0\3\6\4\0"+
    "\12\7\1\0\1\6\21\0\1\6\1\0\6\6\3\0\3\6\1\0"+
    "\4\6\3\0\2\6\1\0\1\6\1\0\2\6\3\0\2\6\3\0"+
    "\3\6\3\0\10\6\1\0\3\6\55\0\11\7\25\0\10\6\1\0"+
    "\3\6\1\0\27\6\1\0\12\6\1\0\5\6\46\0\2\6\4\0"+
    "\12\7\25\0\10\6\1\0\3\6\1\0\27\6\1\0\12\6\1\0"+
    "\5\6\3\0\1\6\40\0\1\6\1\0\2\6\4\0\12\7\25\0"+
    "\10\6\1\0\3\6\1\0\27\6\1\0\20\6\46\0\2\6\4\0"+
    "\12\7\25\0\22\6\3\0\30\6\1\0\11\6\1\0\1\6\2\0"+
    "\7\6\72\0\60\6\1\0\2\6\14\0\7\6\11\0\12\7\47\0"+
    "\2\6\1\0\1\6\2\0\2\6\1\0\1\6\2\0\1\6\6\0"+
    "\4\6\1\0\7\6\1\0\3\6\1\0\1\6\1\0\1\6\2\0"+
    "\2\6\1\0\4\6\1\0\2\6\11\0\1\6\2\0\5\6\1\0"+
    "\1\6\11\0\12\7\2\0\2\6\42\0\1\6\37\0\12\7\26\0"+
    "\10\6\1\0\42\6\35\0\4\6\164\0\42\6\1\0\5\6\1\0"+
    "\2\6\25\0\12\7\6\0\6\6\112\0\46\6\12\0\51\6\7\0"+
    "\132\6\5\0\104\6\5\0\122\6\6\0\7\6\1\0\77\6\1\0"+
    "\1\6\1\0\4\6\2\0\7\6\1\0\1\6\1\0\4\6\2\0"+
    "\47\6\1\0\1\6\1\0\4\6\2\0\37\6\1\0\1\6\1\0"+
    "\4\6\2\0\7\6\1\0\1\6\1\0\4\6\2\0\7\6\1\0"+
    "\7\6\1\0\27\6\1\0\37\6\1\0\1\6\1\0\4\6\2\0"+
    "\7\6\1\0\47\6\1\0\23\6\16\0\11\7\56\0\125\6\14\0"+
    "\u026c\6\2\0\10\6\12\0\32\6\5\0\113\6\25\0\15\6\1\0"+
    "\4\6\16\0\22\6\16\0\22\6\16\0\15\6\1\0\3\6\17\0"+
    "\64\6\43\0\1\6\4\0\1\6\3\0\12\7\46\0\12\7\6\0"+
    "\130\6\10\0\51\6\127\0\35\6\51\0\12\7\36\6\2\0\5\6"+
    "\u038b\0\154\6\224\0\234\6\4\0\132\6\6\0\26\6\2\0\6\6"+
    "\2\0\46\6\2\0\6\6\2\0\10\6\1\0\1\6\1\0\1\6"+
    "\1\0\1\6\1\0\37\6\2\0\65\6\1\0\7\6\1\0\1\6"+
    "\3\0\3\6\1\0\7\6\3\0\4\6\2\0\6\6\4\0\15\6"+
    "\5\0\3\6\1\0\7\6\53\0\2\1\107\0\1\6\15\0\1\6"+
    "\202\0\1\6\4\0\1\6\2\0\12\6\1\0\1\6\3\0\5\6"+
    "\6\0\1\6\1\0\1\6\1\0\1\6\1\0\4\6\1\0\3\6"+
    "\1\0\7\6\3\0\3\6\5\0\5\6\u0ebb\0\2\6\52\0\5\6"+
    "\5\0\2\6\4\0\126\6\6\0\3\6\1\0\132\6\1\0\4\6"+
    "\5\0\50\6\4\0\136\6\21\0\30\6\70\0\20\6\u0200\0\u19b6\6"+
    "\112\0\u51a6\6\132\0\u048d\6\u0773\0\u2ba4\6\u215c\0\u012e\6\2\0\73\6"+
    "\225\0\7\6\14\0\5\6\5\0\1\6\1\0\12\6\1\0\15\6"+
    "\1\0\5\6\1\0\1\6\1\0\2\6\1\0\2\6\1\0\154\6"+
    "\41\0\u016b\6\22\0\100\6\2\0\66\6\50\0\14\6\164\0\5\6"+
    "\1\0\207\6\23\0\12\7\7\0\32\6\6\0\32\6\13\0\131\6"+
    "\3\0\6\6\2\0\6\6\2\0\6\6\2\0\3\6\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\1\3\1\4\1\5\2\6\1\7"+
    "\1\10\1\11\1\12\6\5\1\13\11\5\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\0\1\41\1\37\1\1\1\42"+
    "\1\43\1\44\1\45\1\46\3\43\1\47\2\43\1\2"+
    "\1\0\1\50\1\51\1\52\1\0\1\52\2\0\1\53"+
    "\1\54\1\55\1\56\1\57\10\5\1\60\2\5\1\61"+
    "\22\5\1\62\1\63\1\64\1\65\1\66\1\67\1\70"+
    "\1\71\1\72\1\73\1\74\1\75\1\76\1\77\1\100"+
    "\2\101\1\102\1\103\1\101\1\104\1\105\1\106\1\107"+
    "\1\110\1\111\7\0\1\112\1\52\1\0\1\113\5\5"+
    "\1\114\4\5\1\115\11\5\1\116\6\5\1\117\6\5"+
    "\1\120\1\5\1\121\1\122\1\123\1\124\1\125\1\126"+
    "\1\127\2\0\5\5\1\130\1\5\1\131\6\5\1\132"+
    "\4\5\1\133\1\134\11\5\1\135\1\5\1\136\1\137"+
    "\1\140\1\0\5\5\1\141\1\142\1\143\4\5\1\144"+
    "\1\5\1\145\1\5\1\146\3\5\1\147\4\5\1\150"+
    "\5\5\1\151\1\5\1\152\2\5\1\153\1\154\1\155"+
    "\2\5\1\156\11\5\1\157\1\160\1\161\1\5\1\162"+
    "\1\163\1\5\1\0\1\5\1\164\2\5\1\165\1\166"+
    "\1\5\1\0\1\5\1\167\1\5\1\170\1\171\1\172"+
    "\1\173";

  private static int [] zzUnpackAction() {
    int [] result = new int[305];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\76\0\174\0\272\0\370\0\u0136\0\u0174\0\u0174"+
    "\0\u01b2\0\u01f0\0\u022e\0\u026c\0\u02aa\0\u02e8\0\u0326\0\u0174"+
    "\0\u0174\0\u0364\0\u03a2\0\u03e0\0\u041e\0\u045c\0\u049a\0\u0174"+
    "\0\u04d8\0\u0516\0\u0554\0\u0592\0\u05d0\0\u060e\0\u064c\0\u068a"+
    "\0\u06c8\0\u0174\0\u0174\0\u0174\0\u0174\0\u0174\0\u0174\0\u0706"+
    "\0\u0744\0\u0782\0\u07c0\0\u0174\0\u07fe\0\u083c\0\u087a\0\u08b8"+
    "\0\u08f6\0\u0934\0\u0174\0\u0174\0\u0972\0\u0174\0\u09b0\0\u0174"+
    "\0\u09ee\0\u09b0\0\u0174\0\u0174\0\u0174\0\u0174\0\u0174\0\u0a2c"+
    "\0\u0a6a\0\u0aa8\0\u0ae6\0\u0b24\0\u0b62\0\u0ba0\0\u0bde\0\u0174"+
    "\0\u0174\0\u0c1c\0\u0c5a\0\u0c98\0\u0cd6\0\u0d14\0\u0174\0\u0174"+
    "\0\u0d52\0\u022e\0\u022e\0\u0d90\0\u0dce\0\u0e0c\0\u0e4a\0\u0e88"+
    "\0\u0ec6\0\u0f04\0\u0f42\0\u022e\0\u0f80\0\u0fbe\0\u022e\0\u0ffc"+
    "\0\u103a\0\u1078\0\u10b6\0\u10f4\0\u1132\0\u1170\0\u11ae\0\u11ec"+
    "\0\u122a\0\u1268\0\u12a6\0\u12e4\0\u1322\0\u1360\0\u139e\0\u13dc"+
    "\0\u141a\0\u1458\0\u0174\0\u1496\0\u0174\0\u14d4\0\u1512\0\u0174"+
    "\0\u0174\0\u1550\0\u0174\0\u158e\0\u0174\0\u0174\0\u0174\0\u0174"+
    "\0\u0174\0\u15cc\0\u0174\0\u0174\0\u160a\0\u0174\0\u0174\0\u0174"+
    "\0\u0174\0\u0174\0\u0174\0\u0a2c\0\u1648\0\u0aa8\0\u0b24\0\u0b62"+
    "\0\u1686\0\u16c4\0\u0c5a\0\u1702\0\u1702\0\u0174\0\u1740\0\u177e"+
    "\0\u17bc\0\u17fa\0\u1838\0\u022e\0\u1876\0\u18b4\0\u18f2\0\u1930"+
    "\0\u022e\0\u196e\0\u19ac\0\u19ea\0\u1a28\0\u1a66\0\u1aa4\0\u1ae2"+
    "\0\u1b20\0\u1b5e\0\u022e\0\u1b9c\0\u1bda\0\u1c18\0\u1c56\0\u1c94"+
    "\0\u1cd2\0\u022e\0\u1d10\0\u1d4e\0\u1d8c\0\u1dca\0\u1e08\0\u1e46"+
    "\0\u022e\0\u1e84\0\u0174\0\u0174\0\u1ec2\0\u0174\0\u0174\0\u0174"+
    "\0\u0174\0\u1f00\0\u1f3e\0\u1f7c\0\u1fba\0\u1ff8\0\u2036\0\u2074"+
    "\0\u022e\0\u20b2\0\u022e\0\u20f0\0\u212e\0\u216c\0\u21aa\0\u21e8"+
    "\0\u2226\0\u022e\0\u2264\0\u22a2\0\u22e0\0\u231e\0\u022e\0\u022e"+
    "\0\u235c\0\u239a\0\u23d8\0\u2416\0\u2454\0\u2492\0\u24d0\0\u250e"+
    "\0\u254c\0\u022e\0\u258a\0\u022e\0\u0174\0\u0174\0\u15cc\0\u25c8"+
    "\0\u2606\0\u2644\0\u2682\0\u26c0\0\u022e\0\u022e\0\u022e\0\u26fe"+
    "\0\u273c\0\u277a\0\u27b8\0\u022e\0\u27f6\0\u022e\0\u2834\0\u022e"+
    "\0\u2872\0\u28b0\0\u28ee\0\u022e\0\u292c\0\u296a\0\u29a8\0\u29e6"+
    "\0\u022e\0\u2a24\0\u2a62\0\u2aa0\0\u2ade\0\u2b1c\0\u022e\0\u2b5a"+
    "\0\u022e\0\u2b98\0\u2bd6\0\u022e\0\u022e\0\u022e\0\u2c14\0\u2c52"+
    "\0\u022e\0\u2c90\0\u2cce\0\u2d0c\0\u2d4a\0\u2d88\0\u2dc6\0\u2e04"+
    "\0\u2e42\0\u2e80\0\u022e\0\u022e\0\u022e\0\u2ebe\0\u022e\0\u022e"+
    "\0\u2efc\0\u2f3a\0\u2f78\0\u022e\0\u2fb6\0\u2ff4\0\u022e\0\u022e"+
    "\0\u3032\0\u3070\0\u30ae\0\u022e\0\u30ec\0\u022e\0\u0174\0\u022e"+
    "\0\u022e";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[305];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\3\10\1\11\1\12\1\13\1\7\1\14\1\15"+
    "\1\13\1\16\1\13\1\17\1\20\1\7\1\21\1\13"+
    "\1\22\1\23\1\24\1\13\1\25\1\26\1\27\1\10"+
    "\1\30\1\31\1\32\1\33\1\34\1\13\1\35\2\13"+
    "\1\36\2\13\1\37\1\40\1\13\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\50\1\51\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\10\2\65\1\66\14\65\1\67\54\65\1\70"+
    "\1\66\2\71\1\66\14\71\1\72\12\71\1\73\42\71"+
    "\1\66\4\74\1\75\71\74\1\76\2\77\1\76\2\74"+
    "\10\76\1\100\1\101\55\76\1\77\1\102\2\77\1\102"+
    "\1\103\11\102\1\104\1\105\55\102\1\77\102\0\1\106"+
    "\1\107\52\0\1\110\75\0\1\111\23\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\17\13\34\0\2\112\1\113"+
    "\1\114\1\115\13\0\1\115\55\0\2\15\1\0\1\114"+
    "\1\115\13\0\1\115\55\0\2\114\1\0\1\116\77\0"+
    "\1\117\42\0\1\120\23\0\5\13\1\0\1\13\4\0"+
    "\2\13\1\121\5\13\2\0\1\13\1\122\6\13\1\123"+
    "\1\13\1\124\4\13\32\0\5\13\1\0\1\13\4\0"+
    "\5\13\1\125\1\13\1\126\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\4\13\1\127\3\13\2\0\1\130"+
    "\6\13\1\131\7\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\1\13\1\132\15\13\32\0\5\13\1\0"+
    "\1\13\4\0\7\13\1\133\2\0\7\13\1\134\7\13"+
    "\32\0\4\13\1\135\1\0\1\13\4\0\4\13\1\136"+
    "\3\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\1\13\1\137\15\13\32\0\5\13\1\0"+
    "\1\13\4\0\5\13\1\140\2\13\2\0\14\13\1\141"+
    "\2\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\3\13\1\142\13\13\32\0\5\13\1\0\1\13\4\0"+
    "\7\13\1\143\2\0\17\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\3\13\1\144\2\13\1\145\2\13"+
    "\1\146\5\13\32\0\5\13\1\0\1\13\4\0\1\13"+
    "\1\147\3\13\1\150\2\13\2\0\1\151\6\13\1\152"+
    "\7\13\32\0\5\13\1\0\1\13\4\0\5\13\1\153"+
    "\2\13\2\0\1\154\2\13\1\155\13\13\32\0\5\13"+
    "\1\0\1\13\4\0\1\13\1\156\6\13\2\0\6\13"+
    "\1\157\10\13\32\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\1\160\6\13\1\161\7\13\104\0\1\162\75\0"+
    "\1\163\1\164\74\0\1\165\1\0\1\166\73\0\1\167"+
    "\102\0\1\170\70\0\1\171\5\0\1\172\67\0\1\173"+
    "\6\0\1\174\66\0\1\175\7\0\1\176\65\0\1\177"+
    "\75\0\1\200\15\0\2\65\1\0\14\65\1\0\54\65"+
    "\2\0\12\201\1\202\4\201\1\203\3\201\1\204\2\201"+
    "\1\205\3\201\1\206\2\201\1\207\1\210\1\201\1\211"+
    "\2\201\1\212\30\201\1\213\1\0\2\71\1\0\14\71"+
    "\1\0\12\71\1\0\42\71\1\0\1\214\2\0\14\214"+
    "\1\215\1\76\54\214\1\0\1\76\2\0\72\76\1\0"+
    "\1\216\2\0\1\216\1\103\11\216\1\217\1\220\55\216"+
    "\7\0\1\103\3\0\1\103\1\0\1\103\4\0\10\103"+
    "\2\0\17\103\24\0\1\217\2\0\14\217\1\221\1\216"+
    "\54\217\1\0\1\216\2\0\72\216\1\0\2\106\1\10"+
    "\72\106\1\10\5\107\1\222\70\107\10\0\2\112\1\0"+
    "\1\114\1\115\13\0\1\115\55\0\2\223\2\0\1\223"+
    "\4\0\1\223\2\0\1\223\2\0\2\223\2\0\1\223"+
    "\1\0\1\223\5\0\1\223\42\0\2\114\2\0\1\115"+
    "\13\0\1\115\55\0\2\224\3\0\1\225\52\0\1\225"+
    "\20\0\1\226\70\0\5\13\1\0\1\13\4\0\3\13"+
    "\1\227\4\13\2\0\1\13\1\230\3\13\1\231\11\13"+
    "\32\0\5\13\1\0\1\13\4\0\10\13\2\0\13\13"+
    "\1\232\3\13\32\0\5\13\1\0\1\13\4\0\4\13"+
    "\1\233\3\13\2\0\17\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\14\13\1\234\2\13\32\0\5\13"+
    "\1\0\1\13\4\0\10\13\2\0\1\235\16\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\1\13\1\236"+
    "\3\13\1\237\11\13\32\0\5\13\1\0\1\13\4\0"+
    "\2\13\1\240\5\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\7\13\1\241\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\4\13\1\242\3\13\2\0\10\13"+
    "\1\243\6\13\32\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\5\13\1\244\11\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\1\13\1\245\15\13\32\0\5\13"+
    "\1\0\1\13\4\0\10\13\2\0\13\13\1\246\3\13"+
    "\32\0\5\13\1\0\1\13\4\0\1\13\1\247\6\13"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\7\13"+
    "\1\250\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\5\13\1\251\11\13\32\0\5\13\1\0"+
    "\1\13\4\0\5\13\1\252\2\13\2\0\11\13\1\253"+
    "\5\13\32\0\5\13\1\0\1\13\4\0\1\13\1\254"+
    "\6\13\2\0\3\13\1\255\13\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\13\13\1\256\3\13\32\0"+
    "\5\13\1\0\1\13\4\0\2\13\1\257\5\13\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\2\13\1\260"+
    "\5\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\4\13\1\261\3\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\3\13\1\262\13\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\2\13\1\263"+
    "\14\13\32\0\5\13\1\0\1\13\4\0\3\13\1\264"+
    "\4\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\1\13\1\265\6\13\2\0\7\13\1\266\7\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\5\13\1\267"+
    "\11\13\32\0\5\13\1\0\1\13\4\0\1\13\1\270"+
    "\6\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\3\13\1\271\13\13\32\0\5\13\1\0"+
    "\1\13\4\0\1\13\1\272\6\13\2\0\17\13\104\0"+
    "\1\273\75\0\1\274\1\275\74\0\1\276\75\0\1\277"+
    "\75\0\1\300\75\0\1\301\25\0\2\302\2\0\1\302"+
    "\4\0\1\302\2\0\1\302\2\0\2\302\2\0\1\302"+
    "\1\0\1\302\5\0\1\302\42\0\2\303\2\0\1\303"+
    "\4\0\1\303\2\0\1\303\2\0\2\303\2\0\1\303"+
    "\1\0\1\303\5\0\1\303\32\0\1\214\2\0\72\214"+
    "\1\0\1\217\2\0\72\217\1\0\4\107\1\10\1\222"+
    "\70\107\10\0\2\224\72\0\5\13\1\0\1\13\4\0"+
    "\4\13\1\304\3\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\5\13\1\305\11\13\32\0"+
    "\5\13\1\0\1\13\4\0\7\13\1\306\2\0\17\13"+
    "\32\0\5\13\1\0\1\13\4\0\4\13\1\307\3\13"+
    "\2\0\7\13\1\310\7\13\32\0\5\13\1\0\1\13"+
    "\4\0\4\13\1\311\3\13\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\10\13\2\0\1\13\1\312\15\13"+
    "\32\0\5\13\1\0\1\13\4\0\7\13\1\313\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\3\13\1\314"+
    "\4\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\1\13\1\315\3\13\1\316\11\13\32\0"+
    "\5\13\1\0\1\13\4\0\7\13\1\317\2\0\17\13"+
    "\32\0\5\13\1\0\1\13\4\0\10\13\2\0\1\320"+
    "\16\13\32\0\5\13\1\0\1\13\4\0\7\13\1\321"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\7\13"+
    "\1\322\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\7\13\1\323\2\0\17\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\5\13\1\324\11\13\32\0\5\13"+
    "\1\0\1\13\4\0\10\13\2\0\1\325\16\13\32\0"+
    "\5\13\1\0\1\13\4\0\5\13\1\326\2\13\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\7\13\1\327"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\1\13\1\330\15\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\7\13\1\331\7\13\32\0\5\13"+
    "\1\0\1\13\4\0\7\13\1\332\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\1\333\16\13"+
    "\32\0\5\13\1\0\1\13\4\0\3\13\1\334\4\13"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\1\13\1\335\15\13\32\0\5\13\1\0\1\13"+
    "\4\0\4\13\1\336\3\13\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\10\13\2\0\4\13\1\337\12\13"+
    "\32\0\5\13\1\0\1\13\4\0\10\13\2\0\16\13"+
    "\1\340\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\5\13\1\341\11\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\6\13\1\342\10\13\32\0\5\13\1\0"+
    "\1\13\4\0\4\13\1\343\3\13\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\6\13\1\344\1\13\2\0"+
    "\17\13\104\0\1\345\25\0\2\346\2\0\1\346\4\0"+
    "\1\346\2\0\1\346\2\0\2\346\2\0\1\346\1\0"+
    "\1\346\5\0\1\346\42\0\2\347\2\0\1\347\4\0"+
    "\1\347\2\0\1\347\2\0\2\347\2\0\1\347\1\0"+
    "\1\347\5\0\1\347\40\0\5\13\1\0\1\13\4\0"+
    "\5\13\1\350\2\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\1\351\16\13\32\0\5\13"+
    "\1\0\1\13\4\0\10\13\2\0\3\13\1\352\13\13"+
    "\32\0\5\13\1\0\1\13\4\0\7\13\1\353\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\3\13\1\354\13\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\1\13\1\355\15\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\6\13\1\356\10\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\5\13\1\357"+
    "\11\13\32\0\5\13\1\0\1\13\4\0\1\13\1\360"+
    "\6\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\5\13\1\361\11\13\32\0\5\13\1\0"+
    "\1\13\4\0\5\13\1\362\2\13\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\2\13\1\363\5\13\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\3\13\1\364\13\13\32\0\5\13\1\0\1\13\4\0"+
    "\3\13\1\365\4\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\4\13\1\366\12\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\3\13\1\367"+
    "\13\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\14\13\1\370\2\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\7\13\1\371\7\13\32\0\5\13\1\0"+
    "\1\13\4\0\4\13\1\372\3\13\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\5\13\1\373"+
    "\11\13\32\0\5\13\1\0\1\13\4\0\7\13\1\374"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\1\13"+
    "\1\375\6\13\2\0\17\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\1\376\16\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\1\377\16\13\32\0\5\13"+
    "\1\0\1\13\4\0\7\13\1\u0100\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\7\13\1\u0101\2\0\17\13"+
    "\32\0\5\13\1\0\1\13\4\0\6\13\1\u0102\1\13"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\2\13"+
    "\1\u0103\5\13\2\0\17\13\32\0\5\13\1\0\1\13"+
    "\4\0\2\13\1\u0104\5\13\2\0\10\13\1\u0105\6\13"+
    "\32\0\5\13\1\0\1\13\4\0\10\13\2\0\12\13"+
    "\1\u0106\4\13\32\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\5\13\1\u0107\11\13\32\0\5\13\1\0\1\13"+
    "\4\0\2\13\1\u0108\5\13\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\7\13\1\u0109\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\4\13\1\u010a\3\13\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\6\13\1\u010b"+
    "\1\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\6\13\1\u010c\10\13\32\0\5\13\1\0"+
    "\1\13\4\0\2\13\1\u010d\5\13\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\10\13\1\u010e"+
    "\6\13\32\0\5\13\1\0\1\13\4\0\4\13\1\u010f"+
    "\3\13\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\1\13\1\u0110\6\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\3\13\1\u0111\4\13\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\15\13\1\u0112"+
    "\1\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\5\13\1\u0113\11\13\32\0\5\13\1\0\1\13\4\0"+
    "\3\13\1\u0114\4\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\7\13\1\u0115\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\3\13\1\u0116\4\13\2\0\17\13"+
    "\32\0\5\13\1\0\1\13\4\0\10\13\2\0\1\u0117"+
    "\16\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\1\u0118\16\13\32\0\5\13\1\0\1\13\4\0\7\13"+
    "\1\u0119\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\5\13\1\u011a\2\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\10\13\2\0\5\13\1\u011b\11\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\1\13\1\u011c"+
    "\15\13\32\0\5\13\1\0\1\13\4\0\10\13\2\0"+
    "\11\13\1\u011d\5\13\32\0\5\13\1\0\1\13\4\0"+
    "\10\13\2\0\7\13\1\u011e\7\13\32\0\5\13\1\0"+
    "\1\13\4\0\7\13\1\u011f\2\0\17\13\32\0\5\13"+
    "\1\0\1\13\4\0\7\13\1\u0120\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\5\13\1\u0121"+
    "\11\13\32\0\5\13\1\0\1\13\4\0\10\13\1\u0122"+
    "\1\0\17\13\32\0\5\13\1\0\1\13\4\0\7\13"+
    "\1\u0123\2\0\17\13\32\0\5\13\1\0\1\13\4\0"+
    "\4\13\1\u0124\3\13\2\0\17\13\32\0\5\13\1\0"+
    "\1\13\4\0\3\13\1\u0125\4\13\2\0\17\13\32\0"+
    "\5\13\1\0\1\13\4\0\2\13\1\u0126\5\13\2\0"+
    "\17\13\32\0\5\13\1\0\1\13\4\0\7\13\1\u0127"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\2\13"+
    "\1\u0128\5\13\2\0\17\13\32\0\5\13\1\0\1\13"+
    "\4\0\7\13\1\u0129\2\0\17\13\56\0\1\u012a\51\0"+
    "\5\13\1\0\1\13\4\0\10\13\2\0\7\13\1\u012b"+
    "\7\13\32\0\5\13\1\0\1\13\4\0\7\13\1\u012c"+
    "\2\0\17\13\32\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\5\13\1\u012d\11\13\32\0\5\13\1\0\1\13"+
    "\4\0\6\13\1\u012e\1\13\2\0\17\13\24\0\32\u012a"+
    "\1\u012f\43\u012a\6\0\5\13\1\0\1\13\4\0\10\13"+
    "\2\0\10\13\1\u0130\6\13\32\0\5\13\1\0\1\13"+
    "\4\0\10\13\2\0\1\13\1\u0131\15\13\24\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[12586];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\2\11\7\1\2\11\6\1\1\11\11\1\6\11"+
    "\4\1\1\11\6\1\2\11\1\1\1\11\1\0\1\11"+
    "\2\1\5\11\7\1\1\0\2\11\1\1\1\0\1\1"+
    "\2\0\2\11\42\1\1\11\1\1\1\11\2\1\2\11"+
    "\1\1\1\11\1\1\5\11\1\1\2\11\1\1\6\11"+
    "\7\0\2\1\1\0\1\11\44\1\2\11\1\1\4\11"+
    "\2\0\41\1\2\11\1\0\72\1\1\0\7\1\1\0"+
    "\4\1\1\11\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[305];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;
  
  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /** the stack of open (nested) input streams to read from */
  private java.util.Stack zzStreams = new java.util.Stack();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtEOF;
    boolean zzEOFDone;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, 
                  char [] zzBuffer, boolean zzAtEOF, boolean zzEOFDone, int yyline, int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.yyline         = yyline;
      this.yycolumn       = yycolumn;
    }
  }

  /* user code: */

  protected JooSymbol symbol(int sym) {
    JooSymbol result = new JooSymbol(sym, fileName, yyline + 1, yycolumn + 1, whitespace, yytext());
    whitespace = "";
    return result;
  }

  protected JooSymbol symbol(int sym, Object value) {
    JooSymbol result = new JooSymbol(sym, fileName, yyline + 1, yycolumn + 1, whitespace, yytext(), value);
    whitespace = "";
    return result;
  }

  protected JooSymbol multiStateSymbol(int sym, Object value) {
    JooSymbol result = new JooSymbol(sym, fileName, yyline + 1, yycolumn + 1, whitespace, multiStateText, value);
    whitespace = "";
    return result;
  }

  protected void startRegexp(JooSymbol regexpStart) {
    multiStateText = "";
    string.setLength(0);
    whitespace = regexpStart.getWhitespace();
    assert(regexpStart.sym == sym.DIV || regexpStart.sym == sym.DIVEQ);
    pushback(regexpStart.sym == sym.DIVEQ ? 2 : 1);
    yybegin(REGEXP_START);
  }

  // workaround for bug in jflex column counting, works only if no newline is in these n characters 
  private void pushback(int n) {
    yypushback(n);
    yycolumn -= n;
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1318) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }
    
    // numRead < 0) 
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopstream (usually in an <<EOF>> action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtEOF, zzEOFDone,
                        yyline, yycolumn)
    );
    zzAtEOF  = false;
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yycolumn = 0;
  }
    

  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack. 
   *
   * @throws java.util.EmptyStackException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos ;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    yyline         = s.yyline;
    yycolumn       = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left 
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol scan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;
      char [] zzCMapL = ZZ_CMAP;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 51: 
          { return symbol(GTEQ);
          }
        case 124: break;
        case 27: 
          { return symbol(XOR);
          }
        case 125: break;
        case 19: 
          { return symbol(GT);
          }
        case 126: break;
        case 91: 
          { return symbol(BOOL_LITERAL, new Boolean(true));
          }
        case 127: break;
        case 80: 
          { return symbol(VAR);
          }
        case 128: break;
        case 5: 
          { return symbol(IDE, yytext());
          }
        case 129: break;
        case 55: 
          { return symbol(NOTEQ);
          }
        case 130: break;
        case 14: 
          { return symbol(LBRACE);
          }
        case 131: break;
        case 18: 
          { return symbol(EQ);
          }
        case 132: break;
        case 43: 
          { return symbol(MINUSMINUS);
          }
        case 133: break;
        case 88: 
          { return symbol(NULL_LITERAL, null);
          }
        case 134: break;
        case 117: 
          { return symbol(CONTINUE);
          }
        case 135: break;
        case 77: 
          { return symbol(USE);
          }
        case 136: break;
        case 48: 
          { return symbol(DO);
          }
        case 137: break;
        case 46: 
          { return symbol(IS);
          }
        case 138: break;
        case 70: 
          { multiStateText += yytext(); string.append( '\r' );
          }
        case 139: break;
        case 62: 
          { return symbol(PLUSPLUS);
          }
        case 140: break;
        case 69: 
          { multiStateText += yytext(); string.append( '\b' );
          }
        case 141: break;
        case 37: 
          { multiStateText += yytext(); string.append(yytext()); yybegin(REGEXP_REST);
          }
        case 142: break;
        case 20: 
          { return symbol(LT);
          }
        case 143: break;
        case 112: 
          { return symbol(EXTENDS);
          }
        case 144: break;
        case 86: 
          { return symbol(ANDANDEQ);
          }
        case 145: break;
        case 57: 
          { return symbol(ANDEQ);
          }
        case 146: break;
        case 110: 
          { return symbol(PUBLIC);
          }
        case 147: break;
        case 64: 
          { return symbol(MODEQ);
          }
        case 148: break;
        case 68: 
          { multiStateText += yytext(); string.append( '\"' );
          }
        case 149: break;
        case 6: 
          { return symbol(INT_LITERAL, new Integer(yytext()));
          }
        case 150: break;
        case 73: 
          { multiStateText += yytext(); string.append( '\'' );
          }
        case 151: break;
        case 2: 
          { whitespace += yytext();
          }
        case 152: break;
        case 66: 
          { multiStateText += yytext(); string.append( '\\' );
          }
        case 153: break;
        case 102: 
          { return symbol(THROW);
          }
        case 154: break;
        case 45: 
          { return symbol(IN);
          }
        case 155: break;
        case 31: 
          { multiStateText += yytext(); string.append( yytext() );
          }
        case 156: break;
        case 50: 
          { return symbol(EQEQ);
          }
        case 157: break;
        case 123: 
          { return symbol(IMPLEMENTS);
          }
        case 158: break;
        case 93: 
          { return symbol(WITH);
          }
        case 159: break;
        case 35: 
          { error("invalid regular expression literal");
          }
        case 160: break;
        case 103: 
          { return symbol(BOOL_LITERAL, new Boolean(false));
          }
        case 161: break;
        case 25: 
          { return symbol(OR);
          }
        case 162: break;
        case 26: 
          { return symbol(PLUS);
          }
        case 163: break;
        case 13: 
          { return symbol(RPAREN);
          }
        case 164: break;
        case 99: 
          { return symbol(CONST);
          }
        case 165: break;
        case 38: 
          { error("unterminated regular expression at end of line");
          }
        case 166: break;
        case 52: 
          { return symbol(RSHIFT);
          }
        case 167: break;
        case 97: 
          { return symbol(CLASS);
          }
        case 168: break;
        case 92: 
          { return symbol(THIS);
          }
        case 169: break;
        case 72: 
          { multiStateText += yytext(); string.append( '\f' );
          }
        case 170: break;
        case 11: 
          { multiStateText = yytext(); yybegin(STRING_DQ); string.setLength(0);
          }
        case 171: break;
        case 41: 
          { return symbol(MULTEQ);
          }
        case 172: break;
        case 115: 
          { return symbol(PRIVATE);
          }
        case 173: break;
        case 56: 
          { return symbol(NAMESPACESEP);
          }
        case 174: break;
        case 83: 
          { return symbol(URSHIFT);
          }
        case 175: break;
        case 113: 
          { return symbol(FINALLY);
          }
        case 176: break;
        case 95: 
          { return symbol(URSHIFTEQ);
          }
        case 177: break;
        case 79: 
          { return symbol(FOR);
          }
        case 178: break;
        case 4: 
          { return symbol(MUL);
          }
        case 179: break;
        case 76: 
          { return symbol(NEW);
          }
        case 180: break;
        case 40: 
          { return symbol(DIVEQ);
          }
        case 181: break;
        case 33: 
          { multiStateText += yytext(); yybegin(YYINITIAL); return multiStateSymbol(STRING_LITERAL, string.toString());
          }
        case 182: break;
        case 111: 
          { return symbol(DEFAULT);
          }
        case 183: break;
        case 22: 
          { return symbol(QUESTION);
          }
        case 184: break;
        case 3: 
          { return symbol(DIV);
          }
        case 185: break;
        case 47: 
          { return symbol(IF);
          }
        case 186: break;
        case 121: 
          { yypushStream(createIncludeReader(yytext()));
          }
        case 187: break;
        case 114: 
          { return symbol(PACKAGE);
          }
        case 188: break;
        case 63: 
          { return symbol(XOREQ);
          }
        case 189: break;
        case 39: 
          { multiStateText += yytext();
                                    string.append(yytext());
                                    yybegin(YYINITIAL);
                                    return multiStateSymbol(REGEXP_LITERAL, string.toString());
          }
        case 190: break;
        case 107: 
          { return symbol(SWITCH);
          }
        case 191: break;
        case 84: 
          { return symbol(LSHIFTEQ);
          }
        case 192: break;
        case 28: 
          { return symbol(MOD);
          }
        case 193: break;
        case 12: 
          { return symbol(LPAREN);
          }
        case 194: break;
        case 54: 
          { return symbol(LSHIFT);
          }
        case 195: break;
        case 101: 
          { return symbol(BREAK);
          }
        case 196: break;
        case 44: 
          { return symbol(MINUSEQ);
          }
        case 197: break;
        case 87: 
          { return symbol(OROREQ);
          }
        case 198: break;
        case 32: 
          { error("Unterminated string at end of line");
          }
        case 199: break;
        case 106: 
          { return symbol(DELETE);
          }
        case 200: break;
        case 78: 
          { return symbol(TRY);
          }
        case 201: break;
        case 59: 
          { return symbol(OREQ);
          }
        case 202: break;
        case 42: 
          { return symbol(FLOAT_LITERAL, new Double(yytext()));
          }
        case 203: break;
        case 122: 
          { return symbol(INSTANCEOF);
          }
        case 204: break;
        case 10: 
          { return symbol(RBRACK);
          }
        case 205: break;
        case 16: 
          { return symbol(SEMICOLON);
          }
        case 206: break;
        case 36: 
          { multiStateText += yytext(); string.append(yytext()); yybegin(REGEXP_FIRST);
          }
        case 207: break;
        case 105: 
          { return symbol(IMPORT);
          }
        case 208: break;
        case 100: 
          { return symbol(SUPER);
          }
        case 209: break;
        case 89: 
          { return symbol(CASE);
          }
        case 210: break;
        case 85: 
          { return symbol(NOTEQEQ);
          }
        case 211: break;
        case 8: 
          { return symbol(MINUS);
          }
        case 212: break;
        case 71: 
          { multiStateText += yytext(); string.append( '\t' );
          }
        case 213: break;
        case 7: 
          { return symbol(DOT);
          }
        case 214: break;
        case 34: 
          { multiStateText += yytext(); yybegin(YYINITIAL);
                                    return multiStateSymbol(STRING_LITERAL, string.toString());
          }
        case 215: break;
        case 82: 
          { return symbol(RSHIFTEQ);
          }
        case 216: break;
        case 120: 
          { return symbol(PROTECTED);
          }
        case 217: break;
        case 24: 
          { return symbol(AND);
          }
        case 218: break;
        case 30: 
          { multiStateText = yytext(); yybegin(STRING_SQ); string.setLength(0);
          }
        case 219: break;
        case 65: 
          { error("Illegal escape sequence");
          }
        case 220: break;
        case 81: 
          { return symbol(EQEQEQ);
          }
        case 221: break;
        case 23: 
          { return symbol(COLON);
          }
        case 222: break;
        case 53: 
          { return symbol(LTEQ);
          }
        case 223: break;
        case 74: 
          { return symbol(INT_LITERAL, Long.parseLong(yytext().substring(2),16));
          }
        case 224: break;
        case 118: 
          { return symbol(FUNCTION);
          }
        case 225: break;
        case 94: 
          { return symbol(VOID);
          }
        case 226: break;
        case 29: 
          { return symbol(BITNOT);
          }
        case 227: break;
        case 75: 
          { return symbol(REST);
          }
        case 228: break;
        case 21: 
          { return symbol(NOT);
          }
        case 229: break;
        case 15: 
          { return symbol(RBRACE);
          }
        case 230: break;
        case 67: 
          { multiStateText += yytext(); string.append( '\n' );
          }
        case 231: break;
        case 96: 
          { multiStateText += yytext();
                                   char val = (char) Integer.parseInt(yytext().substring(2),16);
                        	   string.append(val);
          }
        case 232: break;
        case 9: 
          { return symbol(LBRACK);
          }
        case 233: break;
        case 60: 
          { return symbol(OROR);
          }
        case 234: break;
        case 49: 
          { return symbol(AS);
          }
        case 235: break;
        case 119: 
          { return symbol(INTERFACE);
          }
        case 236: break;
        case 109: 
          { return symbol(TYPEOF);
          }
        case 237: break;
        case 58: 
          { return symbol(ANDAND);
          }
        case 238: break;
        case 104: 
          { return symbol(WHILE);
          }
        case 239: break;
        case 116: 
          { return symbol(INTERNAL);
          }
        case 240: break;
        case 61: 
          { return symbol(PLUSEQ);
          }
        case 241: break;
        case 90: 
          { return symbol(ELSE);
          }
        case 242: break;
        case 98: 
          { return symbol(CATCH);
          }
        case 243: break;
        case 17: 
          { return symbol(COMMA);
          }
        case 244: break;
        case 1: 
          { error("unrecognized input token");
          }
        case 245: break;
        case 108: 
          { return symbol(RETURN);
          }
        case 246: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {
                if (yymoreStreams()) yypopStream(); else return symbol(EOF);
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
