/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.CommaSeparatedList;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.FunctionDeclaration;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.IdeExpr;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.PackageDeclaration;
import net.jangaroo.jooc.ParenthesizedExpr;
import net.jangaroo.jooc.PredefinedTypeDeclaration;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.SyntacticKeywords;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplyExpr
extends Expr {
    Expr fun;
    ParenthesizedExpr<CommaSeparatedList<Expr>> args;
    private boolean insideNewExpr = false;

    public ApplyExpr(Expr fun, JooSymbol lParen, CommaSeparatedList<Expr> args, JooSymbol rParen) {
        this.fun = fun;
        this.args = new ParenthesizedExpr<CommaSeparatedList<Expr>>(lParen, args, rParen);
    }

    public boolean isInsideNewExpr() {
        return this.insideNewExpr;
    }

    public void setInsideNewExpr(boolean insideNewExpr) {
        this.insideNewExpr = insideNewExpr;
    }

    @Override
    public void scope(Scope scope) {
        this.fun.scope(scope);
        this.args.scope(scope);
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        this.generateFunJsCode(out);
        if (this.args != null) {
            this.args.generateCode(out);
        }
    }

    private void generateFunJsCode(JsWriter out) throws IOException {
        if (this.isTypeCast()) {
            out.beginComment();
            this.fun.generateCode(out);
            out.endComment();
        } else {
            JooSymbol funSymbol;
            if (this.fun instanceof IdeExpr && SyntacticKeywords.RESERVED_WORDS.contains((funSymbol = ((IdeExpr)this.fun).ide.getSymbol()).getText())) {
                out.writeSymbolWhitespace(funSymbol);
                out.writeToken(new StringBuffer().append("$$").append(funSymbol.getText()).toString());
                return;
            }
            this.fun.generateCode(out);
        }
    }

    private boolean isTypeCast() {
        return this.fun instanceof IdeExpr && !this.isInsideNewExpr() && this.isNonTopLevelType((IdeExpr)this.fun);
    }

    private boolean isNonTopLevelType(IdeExpr fun) {
        Ide ide = fun.ide;
        IdeDeclaration declaration = ide.getDeclaration(false);
        return declaration != null && (declaration instanceof ClassDeclaration || declaration instanceof PredefinedTypeDeclaration || declaration instanceof FunctionDeclaration && declaration.isConstructor()) && (declaration.isClassMember() || declaration.getParentDeclaration() instanceof PackageDeclaration && ((PackageDeclaration)declaration.getParentDeclaration()).getQualifiedName().length > 0);
    }

    @Override
    public Expr analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.fun = this.fun.analyze(this, context);
        if (this.args != null) {
            this.args.analyze(this, context);
        }
        return this;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.fun.getSymbol();
    }

    @Override
    public /* synthetic */ AstNode analyze(AstNode x0, AnalyzeContext x1) {
        return this.analyze(x0, x1);
    }
}

