/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Scope;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBody
extends NodeImplBase {
    JooSymbol lBrace;
    List<AstNode> declararations;
    JooSymbol rBrace;

    public List<AstNode> getDeclararations() {
        return this.declararations;
    }

    public ClassBody(JooSymbol lBrace, List<AstNode> declararations, JooSymbol rBrace) {
        this.lBrace = lBrace;
        this.declararations = declararations;
        this.rBrace = rBrace;
    }

    @Override
    public void scope(Scope scope) {
        for (AstNode node : this.declararations) {
            node.scope(scope);
        }
    }

    @Override
    protected void generateAsApiCode(JsWriter out) throws IOException {
        out.writeSymbol(this.lBrace);
        this.generateCode(this.declararations, out);
        out.writeSymbol(this.rBrace);
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        out.writeSymbolWhitespace(this.lBrace);
        this.generateCode(this.declararations, out);
        out.writeSymbolWhitespace(this.rBrace);
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.declararations = this.analyze(this, this.declararations, context);
        return this;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.lBrace;
    }
}

