/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.PackageDeclaration;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnit
extends NodeImplBase
implements CodeGenerator {
    private PackageDeclaration packageDeclaration;
    private JooSymbol lBrace;
    private IdeDeclaration primaryDeclaration;
    private JooSymbol rBrace;
    private Set<String> dependencies = new LinkedHashSet<String>();
    private InputSource source;
    private Jooc compiler;

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public CompilationUnit(PackageDeclaration packageDeclaration, JooSymbol lBrace, IdeDeclaration primaryDeclaration, JooSymbol rBrace, List<IdeDeclaration> secondaryDeclarations) {
        this.packageDeclaration = packageDeclaration;
        this.lBrace = lBrace;
        this.primaryDeclaration = primaryDeclaration;
        if (primaryDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)primaryDeclaration).setSecondaryDeclarations(secondaryDeclarations);
        }
        this.rBrace = rBrace;
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(Scope scope) {
                Ide packageIde = CompilationUnit.this.packageDeclaration.getIde();
                if (CompilationUnit.this.primaryDeclaration instanceof ClassDeclaration) {
                    ((ClassDeclaration)CompilationUnit.this.primaryDeclaration).scopeDirectives(scope, packageIde);
                }
                CompilationUnit.this.packageDeclaration.scope(scope);
                CompilationUnit.this.withNewDeclarationScope(CompilationUnit.this.packageDeclaration, scope, new NodeImplBase.Scoped(){

                    public void run(Scope scope) {
                        CompilationUnit.this.primaryDeclaration.scope(scope);
                    }
                });
            }
        });
    }

    public IdeDeclaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public Jooc getCompiler() {
        return this.compiler;
    }

    public void setCompiler(Jooc compiler) {
        this.compiler = compiler;
    }

    public Collection<File> getSourcePath() {
        return this.getCompiler().getConfig().getSourcePath();
    }

    public void setSource(InputSource source) {
        this.source = source;
    }

    public void writeOutput(CompilationUnitSinkFactory writerFactory, boolean verbose) throws Jooc.CompilerError {
        File sourceFile = ((FileInputSource)this.source).getFile();
        CompilationUnitSink sink = writerFactory.createSink(this.packageDeclaration, this.primaryDeclaration, sourceFile, verbose);
        sink.writeOutput(this);
    }

    @Override
    protected void generateAsApiCode(JsWriter out) throws IOException {
        this.packageDeclaration.generateCode(out);
        out.writeSymbol(this.lBrace);
        this.primaryDeclaration.generateCode(out);
        out.writeSymbol(this.rBrace);
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        out.write("joo.classLoader.prepare(");
        this.packageDeclaration.generateCode(out);
        out.beginComment();
        out.writeSymbol(this.lBrace);
        out.endComment();
        this.primaryDeclaration.generateCode(out);
        out.write(",[");
        boolean first = true;
        for (String qname : this.dependencies) {
            if (first) {
                first = false;
            } else {
                out.write(",");
            }
            out.write(new StringBuffer().append('\"').append(qname).append('\"').toString());
        }
        out.write("]");
        out.write(new StringBuffer().append(", \"").append(this.compiler.getRuntimeVersion()).append("\"").toString());
        out.write(new StringBuffer().append(", \"").append(this.compiler.getVersion()).append("\"").toString());
        out.writeSymbolWhitespace(this.rBrace);
        out.write(");");
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.packageDeclaration.analyze(this, context);
        this.primaryDeclaration.analyze(this, context);
        return this;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.packageDeclaration.getSymbol();
    }

    public void addDependency(CompilationUnit otherUnit) {
        IdeDeclaration primaryDeclaration;
        if (otherUnit != null && otherUnit != this && (primaryDeclaration = otherUnit.getPrimaryDeclaration()) instanceof ClassDeclaration && !primaryDeclaration.isNative()) {
            String qname = primaryDeclaration.getQualifiedNameStr();
            this.dependencies.add(qname);
        }
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("(").append(this.getPrimaryDeclaration().getQualifiedNameStr()).append(")").toString();
    }
}

