/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.util.regex.Pattern;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.Declaration;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.QualifiedIde;
import net.jangaroo.jooc.Scope;

public abstract class IdeDeclaration
extends Declaration {
    private static Pattern PRIVATE_MEMBER_NAME = Pattern.compile("^[$](\\p{Alpha}|[_$])(\\p{Alnum}|[_$])*$");
    Ide ide;

    protected IdeDeclaration(JooSymbol[] modifiers, int allowedModifiers, Ide ide) {
        super(modifiers, allowedModifiers);
        this.ide = ide;
        if (ide != null && PRIVATE_MEMBER_NAME.matcher(ide.getName()).matches()) {
            Jooc.warning(ide.getSymbol(), "Jangaroo identifier must not be an ActionScript identifier prefixed with a dollar sign ('$').");
        }
    }

    public Ide getIde() {
        return this.ide;
    }

    public JooSymbol getSymbol() {
        return this.ide.getSymbol();
    }

    public String getName() {
        return this.ide == null ? "" : this.ide.getName();
    }

    public String[] getQualifiedName() {
        AstNode parentDeclaration = this.getParentDeclaration();
        if (!(parentDeclaration instanceof IdeDeclaration)) {
            return this.getIde() == null ? new String[]{} : this.getIde().getQualifiedName();
        }
        String[] prefixName = ((IdeDeclaration)parentDeclaration).getQualifiedName();
        String[] result = new String[prefixName.length + 1];
        System.arraycopy(prefixName, 0, result, 0, prefixName.length);
        result[prefixName.length] = this.ide.getName();
        return result;
    }

    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), ".");
    }

    public void scope(Scope scope) {
        super.scope(scope);
        if (this.ide != null) {
            this.ide.scope(scope);
            IdeDeclaration oldNode = scope.declareIde(this);
            if (oldNode != null) {
                this.handleDuplicateDeclaration(scope, oldNode);
            }
        }
    }

    void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        String msg = "Duplicate declaration of identifier '" + this.getName() + "'";
        if (!this.allowDuplicates(scope)) {
            throw Jooc.error(this.getSymbol(), msg);
        }
        Jooc.warning(this.getSymbol(), msg);
    }

    boolean allowDuplicates(Scope scope) {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isClassMember() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isPrivateStaticMethod() {
        return this.isPrivate() && this.isStatic() && this.isMethod();
    }

    public IdeDeclaration resolveDeclaration() {
        return null;
    }

    public IdeDeclaration resolvePropertyDeclaration(String ide) {
        return null;
    }

    public String toString() {
        return this.getQualifiedNameStr();
    }

    public boolean isPrimaryDeclaration() {
        return this.ide != null && this.ide.getScope() != null && this.ide.getScope().getCompilationUnit() != null && this == this.ide.getScope().getCompilationUnit().getPrimaryDeclaration();
    }

    public /* synthetic */ boolean isNative() {
        return super.isNative();
    }

    public /* synthetic */ boolean isFinal() {
        return super.isFinal();
    }

    public /* synthetic */ boolean isAbstract() {
        return super.isAbstract();
    }

    public /* synthetic */ boolean isStatic() {
        return super.isStatic();
    }

    public /* synthetic */ boolean isPrivateStatic() {
        return super.isPrivateStatic();
    }

    public /* synthetic */ boolean isOverride() {
        return super.isOverride();
    }

    public /* synthetic */ boolean isPrivate() {
        return super.isPrivate();
    }

    public /* synthetic */ boolean isProtected() {
        return super.isProtected();
    }

    public /* synthetic */ boolean isPublic() {
        return super.isPublic();
    }

    public /* synthetic */ ClassDeclaration getClassDeclaration() {
        return super.getClassDeclaration();
    }

    public /* synthetic */ AstNode getParentDeclaration() {
        return super.getParentDeclaration();
    }

    public /* synthetic */ JooSymbol[] getSymModifiers() {
        return super.getSymModifiers();
    }
}

