/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.LiteralExpr;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Scope;

class AnnotationParameter
extends NodeImplBase {
    Ide optName;
    JooSymbol optSymEq;
    LiteralExpr value;

    public AnnotationParameter(Ide optName, JooSymbol optSymEq, LiteralExpr value) {
        this.optName = optName;
        this.optSymEq = optSymEq;
        this.value = value;
    }

    public void scope(Scope scope) {
        if (this.value != null) {
            this.value.scope(scope);
        }
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (this.value != null) {
            this.value = (LiteralExpr)this.value.analyze(this, context);
        }
        return this;
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        if (this.optName != null && this.optSymEq != null) {
            this.optName.generateCode(out);
            out.writeSymbol(this.optSymEq);
        }
        this.value.generateCode(out);
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        if (this.optName != null && this.optSymEq != null) {
            this.optName.generateCode(out);
            out.writeSymbolWhitespace(this.optSymEq);
        } else {
            out.writeToken("$value");
        }
        out.writeToken(":");
        this.value.generateCode(out);
    }

    public JooSymbol getSymbol() {
        return this.optName == null ? this.value.getSymbol() : this.optName.getSymbol();
    }
}

