/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;
import net.jangaroo.jooc.SuperConstructorCallStatement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockStatement
extends Statement {
    JooSymbol lBrace;
    List<AstNode> statements;
    JooSymbol rBrace;
    List<CodeGenerator> blockStartCodeGenerators = new ArrayList<CodeGenerator>(3);

    public BlockStatement(JooSymbol lBrace, List<AstNode> statements, JooSymbol rBrace) {
        this.lBrace = lBrace;
        this.statements = statements;
        this.rBrace = rBrace;
    }

    @Override
    public void scope(Scope scope) {
        this.scope(this.statements, scope);
    }

    public void addBlockStartCodeGenerator(CodeGenerator blockStartCodeGenerator) {
        this.blockStartCodeGenerators.add(blockStartCodeGenerator);
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        out.writeSymbol(this.lBrace);
        for (CodeGenerator codeGenerator : this.blockStartCodeGenerators) {
            codeGenerator.generateCode(out);
        }
        this.generateCode(this.statements, out);
        out.writeSymbol(this.rBrace);
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.statements = this.analyze(this, this.statements, context);
        return this;
    }

    public void checkSuperConstructorCall() {
        for (AstNode o : this.statements) {
            if (!(o instanceof SuperConstructorCallStatement)) continue;
            return;
        }
        throw Jooc.error(this.lBrace, "super constructor must be called directly in method block");
    }

    @Override
    public JooSymbol getSymbol() {
        return this.rBrace;
    }
}

