/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassBody;
import net.jangaroo.jooc.CommaSeparatedList;
import net.jangaroo.jooc.Extends;
import net.jangaroo.jooc.FieldDeclaration;
import net.jangaroo.jooc.FunctionDeclaration;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.IdeType;
import net.jangaroo.jooc.Implements;
import net.jangaroo.jooc.ImportDirective;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Type;
import net.jangaroo.jooc.TypedIdeDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends IdeDeclaration {
    private List<AstNode> directives;
    protected JooSymbol symClass;
    protected Extends optExtends;
    private Map<String, TypedIdeDeclaration> members = new LinkedHashMap<String, TypedIdeDeclaration>();
    private Map<String, TypedIdeDeclaration> staticMembers = new LinkedHashMap<String, TypedIdeDeclaration>();
    private Set<String> classInit = new HashSet<String>();
    private ClassBody body;
    private FunctionDeclaration constructor = null;
    private IdeType thisType;
    private IdeType superType;
    private List<FieldDeclaration> fieldsWithInitializer = new ArrayList<FieldDeclaration>();
    private List<IdeDeclaration> secondaryDeclarations = Collections.EMPTY_LIST;
    protected Implements optImplements;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$jooc$ClassDeclaration;

    public Extends getOptExtends() {
        return this.optExtends;
    }

    public ClassBody getBody() {
        return this.body;
    }

    public FunctionDeclaration getConstructor() {
        return this.constructor;
    }

    public FunctionDeclaration getConstructorDeclaration() {
        return this.constructor;
    }

    public ClassDeclaration(List<AstNode> directives, JooSymbol[] modifiers, JooSymbol cls, Ide ide, Extends ext, Implements impl, ClassBody body) {
        super(modifiers, 895, ide);
        this.directives = directives;
        this.symClass = cls;
        this.optExtends = ext;
        this.optImplements = impl;
        this.body = body;
    }

    public boolean isInterface() {
        return "interface".equals(this.symClass.getText());
    }

    @Override
    public boolean isAbstract() {
        return this.isInterface() || super.isAbstract();
    }

    @Override
    public boolean isStatic() {
        return super.isStatic() || !this.isPrimaryDeclaration();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember() || !this.isPrimaryDeclaration();
    }

    @Override
    public String getName() {
        return this.ide.getName();
    }

    public void setConstructor(FunctionDeclaration methodDeclaration) {
        if (this.constructor != null) {
            throw Jooc.error(methodDeclaration, "Only one constructor allowed per class");
        }
        this.constructor = methodDeclaration;
    }

    @Override
    protected void generateAsApiCode(JsWriter out) throws IOException {
        this.generateCode(this.directives, out);
        this.writeModifiers(out);
        out.writeSymbol(this.symClass);
        this.ide.generateCode(out);
        if (this.optExtends != null) {
            this.optExtends.generateCode(out);
        }
        if (this.optImplements != null) {
            this.optImplements.generateCode(out);
        }
        this.body.generateCode(out);
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        this.generateCode(this.directives, out);
        out.beginString();
        this.writeModifiers(out);
        out.writeSymbol(this.symClass);
        this.ide.generateCode(out);
        if (this.optExtends != null) {
            this.optExtends.generateCode(out);
        }
        if (this.optImplements != null) {
            this.optImplements.generateCode(out);
        }
        out.endString();
        out.write(",");
        out.write("function($$l,$$private){var is=joo.is,as=joo.as,assert=joo.assert,trace=joo.trace,$$bound=joo.boundMethod,$super=$$l+'super'");
        for (TypedIdeDeclaration member : this.members.values()) {
            if (!member.isPrivate() && !member.isOverride()) continue;
            out.write(new StringBuffer().append(",$").append(member.getName()).append("=$$l+'").append(member.getName()).append("'").toString());
        }
        out.write(";return[");
        this.generateClassInits(out);
        this.body.generateCode(out);
        if (this.constructor == null && !this.fieldsWithInitializer.isEmpty()) {
            out.write(new StringBuffer().append("\"public function ").append(this.getName()).append("\",function $").append(this.getName()).append("(){this[$super]();").toString());
            this.generateFieldInitCode(out);
            out.write("}");
        }
        for (IdeDeclaration secondaryDeclaration : this.secondaryDeclarations) {
            secondaryDeclaration.generateJsCode(out);
            out.writeToken(",");
        }
        out.write("];},");
        this.generateStaticMethodList(out);
    }

    private void generateClassInits(JsWriter out) throws IOException {
        boolean first = true;
        for (String qualifiedNameStr : this.classInit) {
            if (first) {
                first = false;
                out.write("function(){joo.classLoader.init(");
            } else {
                out.write(",");
            }
            out.write(qualifiedNameStr);
        }
        if (!first) {
            out.write(");},");
        }
    }

    private void generateStaticMethodList(JsWriter out) throws IOException {
        out.write("[");
        boolean isFirst = true;
        for (TypedIdeDeclaration memberDeclaration : this.staticMembers.values()) {
            if (!memberDeclaration.isMethod() || memberDeclaration.isPrivate() || memberDeclaration.isProtected() || !memberDeclaration.isStatic() || memberDeclaration.isNative()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(",");
            }
            out.write(34);
            out.write(memberDeclaration.getName());
            out.write(34);
        }
        out.write("]");
    }

    void scopeDirectives(Scope scope, Ide packageIde) {
        if (packageIde != null) {
            this.addStarImport(packageIde);
        }
        this.addStarImport(null);
        this.scope(this.directives, scope);
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        this.thisType = new IdeType(new Ide(this.getIde().getSymbol()));
        this.superType = "Object".equals(this.getQualifiedNameStr()) ? null : new IdeType(this.optExtends == null ? new Ide("Object") : this.optExtends.superClass);
        this.thisType.scope(scope);
        if (this.superType != null) {
            this.superType.scope(scope);
        }
        if (this.optImplements != null) {
            this.optImplements.scope(scope);
        }
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(Scope scope) {
                ClassDeclaration.this.withNewDeclarationScope(ClassDeclaration.this, scope, new NodeImplBase.Scoped(){

                    public void run(Scope scope) {
                        Iterator i$ = ClassDeclaration.this.secondaryDeclarations.iterator();
                        while (i$.hasNext()) {
                            IdeDeclaration secondaryDeclaration = (IdeDeclaration)i$.next();
                            secondaryDeclaration.scope(scope);
                        }
                        ClassDeclaration.this.body.scope(scope);
                    }
                });
            }
        });
    }

    @Override
    void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        if (!(oldNode instanceof ImportDirective)) {
            super.handleDuplicateDeclaration(scope, oldNode);
        }
    }

    void addStarImport(Ide packageIde) {
        ImportDirective importDirective = new ImportDirective(packageIde, "*");
        this.directives.add(0, importDirective);
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        this.directives = this.analyze(this, this.directives, context);
        super.analyze(parentNode, context);
        if (this.optExtends != null) {
            this.optExtends.analyze(this, context);
        }
        if (this.optImplements != null) {
            this.optImplements.analyze(this, context);
        }
        this.body.analyze(this, context);
        for (IdeDeclaration secondaryDeclaration : this.secondaryDeclarations) {
            secondaryDeclaration.analyze(this, context);
        }
        return this;
    }

    public void registerMember(TypedIdeDeclaration memberDeclaration) {
        (memberDeclaration.isStatic() ? this.staticMembers : this.members).put(memberDeclaration.getName(), memberDeclaration);
    }

    public TypedIdeDeclaration getMemberDeclaration(String memberName) {
        return this.members.get(memberName);
    }

    public TypedIdeDeclaration getStaticMemberDeclaration(String memberName) {
        return this.staticMembers.get(memberName);
    }

    public void addInitIfClass(Ide ide) {
        IdeDeclaration decl = ide.getDeclaration(false);
        if (decl != null && decl != this && decl instanceof ClassDeclaration) {
            this.classInit.add(decl.getQualifiedNameStr());
        }
    }

    public boolean isSubclassOf(ClassDeclaration classDeclaration) {
        ClassDeclaration superTypeDeclaration = this.getSuperTypeDeclaration();
        return superTypeDeclaration != null && (superTypeDeclaration == classDeclaration || superTypeDeclaration.isSubclassOf(classDeclaration));
    }

    public Type getThisType() {
        return this.thisType;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public void setSecondaryDeclarations(List<IdeDeclaration> secondaryDeclarations) {
        this.secondaryDeclarations = secondaryDeclarations;
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this;
    }

    @Override
    public IdeDeclaration resolvePropertyDeclaration(String ide) {
        return this.resolvePropertyDeclaration1(ide, this, new HashSet<ClassDeclaration>(), new LinkedList<ClassDeclaration>());
    }

    private IdeDeclaration resolvePropertyDeclaration1(String ide, ClassDeclaration classDecl, Set<ClassDeclaration> visited, LinkedList<ClassDeclaration> chain) {
        if (visited.contains(classDecl)) {
            if (chain.contains(classDecl)) {
                throw new Jooc.CompilerError(classDecl.getSymbol(), "cyclic syperclass chain");
            }
            return null;
        }
        visited.add(classDecl);
        int chainSize = chain.size();
        chain.add(classDecl);
        IdeDeclaration declaration = classDecl.getMemberDeclaration(ide);
        if (declaration == null) {
            declaration = classDecl.getStaticMemberDeclaration(ide);
        }
        if (declaration == null && classDecl.optExtends != null) {
            declaration = this.resolvePropertyInSuper(ide, classDecl, visited, chain, classDecl.optExtends.superClass);
        }
        if (declaration == null && classDecl.optImplements != null) {
            CommaSeparatedList<Ide> implemented = classDecl.optImplements.superTypes;
            while (implemented != null && declaration == null) {
                declaration = this.resolvePropertyInSuper(ide, classDecl, visited, chain, (Ide)implemented.head);
                implemented = implemented.tail;
            }
        }
        chain.removeLast();
        if (!$assertionsDisabled && chainSize != chain.size()) {
            throw new AssertionError();
        }
        return declaration;
    }

    private IdeDeclaration resolvePropertyInSuper(String ide, ClassDeclaration classDecl, Set<ClassDeclaration> visited, LinkedList<ClassDeclaration> chain, Ide superIde) {
        IdeDeclaration superClassDecl = superIde.getDeclaration();
        if (superClassDecl != null && !(superClassDecl instanceof ClassDeclaration)) {
            throw new Jooc.CompilerError(classDecl.optExtends.superClass.getSymbol(), "expected class identifier");
        }
        return this.resolvePropertyDeclaration1(ide, (ClassDeclaration)superClassDecl, visited, chain);
    }

    public ClassDeclaration getSuperTypeDeclaration() {
        return this.superType == null ? null : (ClassDeclaration)this.superType.ide.getDeclaration();
    }

    public void addFieldWithInitializer(FieldDeclaration fieldDeclaration) {
        this.fieldsWithInitializer.add(fieldDeclaration);
    }

    public void generateFieldInitCode(JsWriter out) throws IOException {
        for (FieldDeclaration field : this.fieldsWithInitializer) {
            field.generateInitCode(out);
        }
    }

    static {
        Class<?> clazz = class$net$jangaroo$jooc$ClassDeclaration;
        if (clazz == null) {
            clazz = class$net$jangaroo$jooc$ClassDeclaration = new ClassDeclaration[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

