/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.ApplyExpr;
import net.jangaroo.jooc.AsExpr;
import net.jangaroo.jooc.AssignmentOpExpr;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.CommaSeparatedList;
import net.jangaroo.jooc.CompilationUnit;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.FunctionDeclaration;
import net.jangaroo.jooc.FunctionExpr;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.Initializer;
import net.jangaroo.jooc.IsExpr;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NewExpr;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.ObjectField;
import net.jangaroo.jooc.PackageDeclaration;
import net.jangaroo.jooc.ParenthesizedExpr;
import net.jangaroo.jooc.QualifiedIde;
import net.jangaroo.jooc.ReturnStatement;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.VariableDeclaration;

public class Ide
extends NodeImplBase {
    JooSymbol ide;
    private IdeDeclaration declaration;
    private Scope scope;
    private Ide qualified;
    protected boolean bound;
    protected boolean rewriteThis;
    private static final IdeDeclaration NULL_DECL;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$jooc$Ide;

    public Ide(String ide) {
        this(new JooSymbol(ide));
    }

    public static Ide fromQName(JooSymbol qnameSymbol) {
        Ide ide = null;
        int i = 0;
        int j = 0;
        String qname = qnameSymbol.getText();
        String ws = qnameSymbol.getWhitespace();
        do {
            if ((i = qname.indexOf(46, j)) < 0) {
                i = qname.length();
            }
            if (!$assertionsDisabled && i <= 0) {
                throw new AssertionError();
            }
            String segment = qname.substring(j, i - 1);
            JooSymbol symSegment = new JooSymbol(98, qnameSymbol.getFileName(), qnameSymbol.getLine(), qnameSymbol.getColumn() + j, ws, segment);
            ws = "";
            JooSymbol symDot = new JooSymbol(73, qnameSymbol.getFileName(), qnameSymbol.getLine(), qnameSymbol.getColumn() + i, "", ".");
            j = i + 1;
            Ide ide2 = ide = ide == null ? new Ide(symSegment) : new QualifiedIde(ide, symDot, symSegment);
        } while (j < qname.length());
        return ide;
    }

    public Ide(JooSymbol ide) {
        this.ide = ide;
    }

    public Scope getScope() {
        return this.scope;
    }

    public JooSymbol getIde() {
        return this.ide;
    }

    private boolean isThis() {
        return "this".equals(this.ide.getText());
    }

    private boolean needsThisAtRuntime() {
        if (this.isThis() || this.isSuper()) {
            return true;
        }
        if (!this.isQualified() && this.isDeclared()) {
            IdeDeclaration decl = this.getDeclaration();
            return decl.isClassMember() && !decl.isStatic();
        }
        return false;
    }

    private boolean isSuper() {
        return "super".equals(this.ide.getText());
    }

    public void scope(Scope scope) {
        if (this.scope == null) {
            this.scope = scope;
        }
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        out.writeSymbol(this.ide);
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public String getQualifiedNameStr() {
        return this.getName();
    }

    public String getName() {
        return this.ide.getText();
    }

    public JooSymbol getSymbol() {
        return this.ide;
    }

    public boolean isQualifier() {
        return this.qualified != null;
    }

    protected void setQualified(Ide qualifier) {
        this.qualified = qualifier;
    }

    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    public Ide getQualified() {
        return this.qualified;
    }

    protected Ide getQualifier() {
        return null;
    }

    protected boolean isQualifiedByThis() {
        return this.getQualifier() != null && this.getQualifier().isThis();
    }

    protected boolean isQualifiedBySuper() {
        return this.getQualifier() != null && this.getQualifier().isSuper();
    }

    protected boolean isThisAccess() {
        return this.getQualifier() == null || this.getQualifier().isThis();
    }

    public boolean addExternalUsage() {
        IdeDeclaration decl = this.getDeclaration(false);
        if (decl == null || !decl.isPrimaryDeclaration()) {
            return false;
        }
        CompilationUnit currentUnit = this.getScope().getCompilationUnit();
        currentUnit.addDependency(decl.getIde().getScope().getCompilationUnit());
        return true;
    }

    public IdeDeclaration resolveDeclaration() {
        IdeDeclaration decl = this.getDeclaration(false);
        return decl == null ? null : decl.resolveDeclaration();
    }

    public IdeDeclaration getDeclaration() {
        return this.getDeclaration(true);
    }

    public IdeDeclaration getDeclaration(boolean errorIfUndeclared) {
        IdeDeclaration result;
        if (this.declaration == null) {
            this.declaration = this.getScope().lookupDeclaration(this);
            if (this.declaration == null) {
                this.declaration = NULL_DECL;
            } else if (this.declaration.getClassDeclaration() != this.getScope().getClassDeclaration()) {
                if (this.declaration.isPrivate()) {
                    throw new Jooc.CompilerError(this.getSymbol(), "private member access");
                }
                if (this.declaration.isProtected() && !this.getScope().getClassDeclaration().isSubclassOf(this.declaration.getClassDeclaration())) {
                    throw new Jooc.CompilerError(this.getSymbol(), "protected member access of non-superclass");
                }
            }
        }
        IdeDeclaration ideDeclaration = result = this.declaration == NULL_DECL ? null : this.declaration;
        if (result == null && errorIfUndeclared) {
            throw Jooc.error(this.ide, "undeclared identifier '" + this.getName() + "'");
        }
        return result;
    }

    public Ide qualify(JooSymbol symQualifier, JooSymbol symDot) {
        return new QualifiedIde(new Ide(symQualifier), symDot, this.ide);
    }

    public void analyzeAsExpr(AstNode exprParent, Expr parentExpr, AnalyzeContext context) {
        IdeDeclaration memberDeclaration;
        FunctionExpr funExpr;
        if (this.needsThisAtRuntime() && (funExpr = this.scope.getFunctionExpr()) != null) {
            this.rewriteThis = funExpr.notifyThisUsed(this.scope);
        }
        if (this.isSuper()) {
            FunctionDeclaration currentMethod = this.getScope().getMethodDeclaration();
            if (currentMethod == null) {
                throw Jooc.error(this.ide, "use of super is only allowed within non-static methods");
            }
            if (currentMethod.isStatic()) {
                throw Jooc.error(this.ide, "use of super inside static method");
            }
        }
        this.checkDefinedAccessChain();
        if (this.isBoundMethodCandidate(exprParent, parentExpr) && (memberDeclaration = this.getMemberDeclaration()) != null && memberDeclaration.isMethod() && !((FunctionDeclaration)memberDeclaration).isGetterOrSetter() && !memberDeclaration.isStatic()) {
            this.bound = true;
        }
        if (this.scope != null) {
            this.usageInExpr(exprParent);
        }
    }

    public void usageInExpr(AstNode exprParent) {
        ClassDeclaration classDeclaration;
        this.addExternalUsage();
        if (!(exprParent instanceof ApplyExpr || exprParent instanceof NewExpr || exprParent instanceof IsExpr || exprParent instanceof AsExpr || (classDeclaration = this.getScope().getClassDeclaration()) == null)) {
            if (this.isQualified()) {
                classDeclaration.addInitIfClass(this.getQualifier());
            }
            if (!this.isQualifier()) {
                classDeclaration.addInitIfClass(this);
            }
        }
    }

    protected IdeDeclaration getMemberDeclaration() {
        IdeDeclaration declaration = this.getDeclaration(false);
        if (declaration != null && declaration.isClassMember()) {
            return declaration;
        }
        return declaration;
    }

    private void checkDefinedAccessChain() {
        if (!(this.isQualified() || this.isDeclared() || this.isValidPackageAccessChain())) {
            throw Jooc.error(this.ide, "undeclared identifier '" + this.getName() + "'");
        }
    }

    private boolean isValidPackageAccessChain() {
        if (this.isQualifier()) {
            Ide qualified = this.getQualified();
            return qualified.isDeclared() || qualified.isValidPackageAccessChain();
        }
        return false;
    }

    private boolean isDeclared() {
        return this.getDeclaration(false) != null;
    }

    private boolean isBoundMethodCandidate(AstNode exprParent, Expr parentExpr) {
        return exprParent instanceof ParenthesizedExpr || exprParent instanceof CommaSeparatedList || exprParent instanceof Initializer || exprParent instanceof AsExpr || exprParent instanceof ObjectField || exprParent instanceof ReturnStatement || exprParent instanceof AssignmentOpExpr && ((AssignmentOpExpr)exprParent).arg2 == parentExpr;
    }

    protected void generateCodeAsExpr(JsWriter out) throws IOException {
        out.writeSymbolWhitespace(this.ide);
        if (this.isSuper() || this.isThis()) {
            this.writeThis(out);
            return;
        }
        IdeDeclaration decl = this.getDeclaration(false);
        if (decl != null) {
            String qname;
            if (decl.isClassMember()) {
                if (!decl.isPrivateStatic()) {
                    if (decl.isStatic()) {
                        out.writeToken(decl.getClassDeclaration().getQualifiedNameStr());
                    } else {
                        if (this.bound) {
                            this.writeBoundMethodAccess(out, null, null, decl);
                            return;
                        }
                        this.writeThis(out);
                    }
                }
                Ide.writeMemberAccess(decl, null, this, false, out);
                return;
            }
            if (!decl.isClassMember() && decl.getParentDeclaration() instanceof PackageDeclaration && !(qname = ((PackageDeclaration)decl.getParentDeclaration()).getQualifiedNameStr()).isEmpty()) {
                out.writeToken(qname);
                out.writeToken(".");
            }
        }
        out.writeSymbol(this.ide, false);
    }

    private void writeThis(JsWriter out) throws IOException {
        out.writeToken(this.rewriteThis ? "$this" : "this");
    }

    protected void writeBoundMethodAccess(JsWriter out, Ide optIde, JooSymbol optSymDot, IdeDeclaration decl) throws IOException {
        out.writeToken("$$bound(");
        if (optIde != null) {
            optIde.generateCodeAsExpr(out);
        } else {
            this.writeThis(out);
        }
        if (optSymDot != null) {
            out.writeSymbolWhitespace(optSymDot);
        }
        out.writeToken(",");
        if (this.isQualifiedBySuper() || decl.isPrivate()) {
            out.writeToken("$" + this.getName());
        } else {
            out.beginString();
            out.writeToken(this.getName());
            out.endString();
        }
        out.writeToken(")");
    }

    static void writeMemberAccess(IdeDeclaration memberDeclaration, JooSymbol optSymDot, Ide memberIde, boolean writeMemberWhitespace, JsWriter out) throws IOException {
        if (memberDeclaration != null && (memberIde.isQualifiedBySuper() || memberDeclaration.isPrivate())) {
            Ide.writePrivateMemberAccess(optSymDot, memberIde, writeMemberWhitespace, memberDeclaration.isStatic(), out);
            return;
        }
        if (optSymDot == null && memberDeclaration != null && !memberDeclaration.isConstructor()) {
            optSymDot = new JooSymbol(".");
        }
        boolean quote = false;
        if (optSymDot != null) {
            if (memberIde.ide.getText().startsWith("@")) {
                quote = true;
                out.writeSymbolWhitespace(optSymDot);
                out.writeToken("['");
            } else {
                out.writeSymbol(optSymDot);
            }
        }
        out.writeSymbol(memberIde.ide, writeMemberWhitespace);
        if (quote) {
            out.writeToken("']");
        }
    }

    protected static IdeDeclaration resolveMember(IdeDeclaration type, Ide memberIde) {
        IdeDeclaration declaration = null;
        if (type != null) {
            declaration = type.resolvePropertyDeclaration(memberIde.getName());
        }
        return declaration;
    }

    static void writePrivateMemberAccess(JooSymbol optSymDot, Ide memberIde, boolean writeMemberWhitespace, boolean isStatic, JsWriter out) throws IOException {
        if (writeMemberWhitespace) {
            out.writeSymbolWhitespace(memberIde.ide);
        }
        if (isStatic) {
            out.writeToken("$$private");
            if (optSymDot != null) {
                out.writeSymbol(optSymDot);
            } else {
                out.writeToken(".");
            }
            out.writeSymbol(memberIde.ide, false);
        } else {
            out.writeToken("[");
            if (optSymDot != null) {
                out.writeSymbolWhitespace(optSymDot);
            }
            out.writeToken("$" + memberIde.getName());
            out.writeToken("]");
        }
    }

    public String toString() {
        return this.getQualifiedNameStr();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ide ide1 = (Ide)o;
        return !(this.ide == null ? ide1.ide != null : !this.ide.getText().equals(ide1.ide.getText()));
    }

    public int hashCode() {
        int result = this.ide != null ? ((Object)((Object)this.ide)).hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    static {
        Class<?> clazz = class$net$jangaroo$jooc$Ide;
        if (clazz == null) {
            clazz = class$net$jangaroo$jooc$Ide = new Ide[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NULL_DECL = new VariableDeclaration(null, null, null, null);
    }
}

