/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.QualifiedIde;
import net.jangaroo.jooc.Scope;

public class ImportDirective
extends NodeImplBase {
    private static final JooSymbol IMPORT_SYMBOL = new JooSymbol(19, "import");
    private static final JooSymbol DOT_SYMBOL = new JooSymbol(73, ".");
    JooSymbol importKeyword;
    Ide ide;
    private final boolean explicit;

    private static Ide createIde(Ide prefix, JooSymbol symIde) {
        return prefix == null ? new Ide(symIde) : new QualifiedIde(prefix, DOT_SYMBOL, symIde);
    }

    public ImportDirective(Ide packageIde, String typeName) {
        this(IMPORT_SYMBOL, ImportDirective.createIde(packageIde, new JooSymbol(typeName)), false);
    }

    public ImportDirective(JooSymbol importKeyword, Ide ide) {
        this(importKeyword, ide, true);
    }

    private ImportDirective(JooSymbol importKeyword, Ide ide, boolean explicit) {
        this.importKeyword = importKeyword;
        this.ide = ide;
        this.explicit = explicit;
    }

    public void scope(Scope scope) {
        this.ide.scope(scope);
        scope.addImport(this);
    }

    public String getQualifiedName() {
        return this.ide.getQualifiedNameStr();
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        if (this.explicit) {
            out.writeSymbol(this.importKeyword);
            this.ide.generateCode(out);
        }
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        if (this.explicit) {
            out.beginComment();
            out.writeSymbol(this.importKeyword);
            this.ide.generateCode(out);
            out.endComment();
        }
    }

    public JooSymbol getSymbol() {
        return this.importKeyword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportDirective that = (ImportDirective)o;
        if (this.explicit != that.explicit) {
            return false;
        }
        return !(this.ide != null ? !this.ide.equals(that.ide) : that.ide != null);
    }

    public int hashCode() {
        int result = this.ide != null ? this.ide.hashCode() : 0;
        result = 31 * result + (this.explicit ? 1 : 0);
        return result;
    }
}

