/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.QualifiedIde;
import net.jangaroo.jooc.Scope;

public class NamespacedIde
extends Ide {
    private JooSymbol namespace;
    private JooSymbol symNamespaceSep;

    public NamespacedIde(JooSymbol namespace, JooSymbol symNamespaceSep, JooSymbol symIde) {
        super(symIde);
        this.namespace = namespace;
    }

    void warnUndefinedNamespace(Scope scope, Ide namespace) {
    }

    public void scope(Scope scope) {
        super.scope(scope);
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        if (this.namespace.sym == 98) {
            Jooc.warning(this.namespace, "namespaces are not yet implemented, ignoring namespace " + this.namespace.getText());
        }
        return super.analyze(parentNode, context);
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        out.beginComment();
        out.writeSymbol(this.namespace);
        out.writeSymbol(this.symNamespaceSep);
        out.endComment();
        out.writeSymbol(this.ide);
    }

    static String getNamespacePrefix(JooSymbol namespace) {
        return "";
    }

    public String getName() {
        return NamespacedIde.getNamespacePrefix(this.namespace) + super.getName();
    }

    public String[] getQualifiedName() {
        return new String[]{this.namespace.getText(), this.ide.getText()};
    }

    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), "::");
    }

    public JooSymbol getSymbol() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacedIde that = (NamespacedIde)o;
        return this.namespace.getText().equals(that.namespace.getText());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.namespace.getText().hashCode();
        return result;
    }
}

