/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.LabelScope;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImplBase
implements AstNode {
    AstNode parentNode;

    void generateCode(Collection<? extends AstNode> nodes, JsWriter out) throws IOException {
        for (AstNode astNode : nodes) {
            astNode.generateCode(out);
        }
    }

    @Override
    public void generateCode(JsWriter out) throws IOException {
        if (out.isWriteActionScriptApi()) {
            this.generateAsApiCode(out);
        } else {
            this.generateJsCode(out);
        }
    }

    protected abstract void generateJsCode(JsWriter var1) throws IOException;

    protected void generateAsApiCode(JsWriter out) throws IOException {
        this.generateJsCode(out);
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        this.parentNode = parentNode;
        return this;
    }

    public <N extends AstNode> void scope(List<N> nodes, Scope scope) {
        for (AstNode node : nodes) {
            node.scope(scope);
        }
    }

    public <N extends AstNode> List<N> analyze(AstNode parent, List<N> nodes, AnalyzeContext context) {
        ArrayList<AstNode> result = new ArrayList<AstNode>(nodes.size());
        for (AstNode node : nodes) {
            result.add(node.analyze(parent, context));
        }
        return result;
    }

    public void withNewDeclarationScope(AstNode definingNode, Scope scope, Scoped scoped) {
        scoped.run(new DeclarationScope(definingNode, scope));
    }

    public void withNewLabelScope(Statement statement, Scope scope, Scoped scoped) {
        scoped.run(new LabelScope(statement, scope));
    }

    public static interface Scoped {
        public void run(Scope var1);
    }
}

