/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.CommaSeparatedList;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.FunctionDeclaration;
import net.jangaroo.jooc.IdeExpr;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ParenthesizedExpr;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.Statement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SuperConstructorCallStatement
extends Statement {
    Expr fun;
    ParenthesizedExpr<CommaSeparatedList<Expr>> args;
    private ClassDeclaration classDeclaration;

    public SuperConstructorCallStatement(JooSymbol symSuper, JooSymbol lParen, CommaSeparatedList<Expr> args, JooSymbol rParen) {
        this.fun = new IdeExpr(symSuper);
        this.args = new ParenthesizedExpr<CommaSeparatedList<Expr>>(lParen, args, rParen);
    }

    @Override
    public void scope(Scope scope) {
        FunctionDeclaration method = scope.getMethodDeclaration();
        if (method == null || !method.isConstructor()) {
            throw Jooc.error(this.getSymbol(), "must only call super constructor from constructor method");
        }
        if (method.containsSuperConstructorCall()) {
            throw Jooc.error(this.getSymbol(), "must not call super constructor twice");
        }
        method.setContainsSuperConstructorCall(true);
        this.fun.scope(scope);
        if (this.args != null) {
            this.args.scope(scope);
        }
        this.classDeclaration = scope.getClassDeclaration();
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.fun.analyze(this, context);
        if (this.args != null) {
            this.args.analyze(this, context);
        }
        return this;
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        this.generateFunCode(out);
        this.generateArgsCode(out);
        this.classDeclaration.generateFieldInitCode(out);
    }

    protected void generateFunCode(JsWriter out) throws IOException {
        out.writeSymbolWhitespace(this.getSymbol());
        out.writeToken("this[$super]");
    }

    protected void generateArgsCode(JsWriter out) throws IOException {
        if (this.args != null) {
            this.args.generateCode(out);
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.fun.getSymbol();
    }
}

