/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.JoocOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoocCommandLineParser {
    public JoocConfiguration parse(String[] argv) throws CommandLineParseException {
        String[] fileNames;
        CommandLine line;
        JoocConfiguration config = new JoocConfiguration();
        Option help = new Option("help", "print this message");
        OptionBuilder.withDescription((String)"print version information and exit");
        Option version = OptionBuilder.create((String)"version");
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"be extra verbose");
        Option verboseOption = OptionBuilder.create((String)"v");
        OptionBuilder.withDescription((String)"generate debuggable output (possible modes: source, lines, none)");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"mode");
        Option debugOption = OptionBuilder.create((String)"g");
        OptionBuilder.withDescription((String)"automatic semicolon insertion mode, possible modes: error, warn (default), quirk (no warnings)");
        OptionBuilder.hasArg();
        Option autoSemicolonOption = OptionBuilder.create((String)"autosemicolon");
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"destination directory for generated JavaScript files");
        Option destinationDir = OptionBuilder.create((String)"d");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"source root directories, separated by the system dependant path separator character (e.g. ':' on Unix systems, ';' on Windows");
        Option sourcePath = OptionBuilder.create((String)"sourcepath");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"source root directories or jangaroo jars of dependent classes, separated by the system dependent path separator character (e.g. ':' on Unix systems, ';' on Windows");
        Option classPath = OptionBuilder.create((String)"classpath");
        OptionBuilder.withLongOpt((String)"enableassertions");
        OptionBuilder.withDescription((String)"enable assertions");
        Option enableAssertionsOption = OptionBuilder.create((String)"ea");
        OptionBuilder.withLongOpt((String)"apiDir");
        OptionBuilder.withDescription((String)"destination directory where to generate ActionScript API stubs");
        OptionBuilder.hasArg();
        Option apiDestinationDir = OptionBuilder.create((String)"api");
        OptionBuilder.withLongOpt((String)"allowduplicatelocalvariables");
        OptionBuilder.withDescription((String)"allow multiple declarations of local variables");
        Option allowDuplicateLocalVariablesOption = OptionBuilder.create((String)"ad");
        Options options = new Options();
        options.addOption(help);
        options.addOption(version);
        options.addOption(verboseOption);
        options.addOption(debugOption);
        options.addOption(autoSemicolonOption);
        options.addOption(destinationDir);
        options.addOption(sourcePath);
        options.addOption(classPath);
        options.addOption(enableAssertionsOption);
        options.addOption(apiDestinationDir);
        options.addOption(allowDuplicateLocalVariablesOption);
        GnuParser parser2 = new GnuParser();
        try {
            line = parser2.parse(options, argv);
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandLineParseException(e.getMessage(), 3);
        }
        catch (MissingArgumentException e) {
            throw new CommandLineParseException(e.getMessage(), 4);
        }
        catch (ParseException e) {
            throw new CommandLineParseException(e.getMessage(), 3);
        }
        if (line.hasOption("help")) {
            this.printHelp(options);
            return null;
        }
        config.setVersion(line.hasOption("version"));
        config.setVerbose(line.hasOption(verboseOption.getOpt()));
        if (line.hasOption(destinationDir.getOpt())) {
            String destinationDirName = line.getOptionValue(destinationDir.getOpt()).trim();
            File destDir = new File(destinationDirName);
            if (!destDir.exists()) {
                throw new IllegalArgumentException(new StringBuffer().append("destination directory does not exist: ").append(destDir.getAbsolutePath()).toString());
            }
            config.setOutputDirectory(destDir);
        }
        List<File> sp = this.parsePath(line, sourcePath);
        List<File> cp = this.parsePath(line, classPath);
        if (sp != null) {
            config.setSourcePath(sp);
        }
        if (cp != null) {
            config.setClassPath(cp);
        }
        if (line.hasOption(enableAssertionsOption.getOpt())) {
            config.setEnableAssertions(true);
        }
        if (line.hasOption(apiDestinationDir.getOpt())) {
            String destinationDirName = line.getOptionValue(apiDestinationDir.getOpt()).trim();
            File destDir = new File(destinationDirName);
            if (!destDir.exists()) {
                throw new IllegalArgumentException(new StringBuffer().append("destination directory for API stubs does not exist: ").append(destDir.getAbsolutePath()).toString());
            }
            config.setApiOutputDirectory(destDir);
        }
        if (line.hasOption(allowDuplicateLocalVariablesOption.getOpt())) {
            config.setAllowDuplicateLocalVariables(true);
        }
        if (line.hasOption(autoSemicolonOption.getOpt())) {
            String value = line.getOptionValue(autoSemicolonOption.getOpt());
            if (value.equals("error")) {
                config.setSemicolonInsertionMode(JoocOptions.SemicolonInsertionMode.ERROR);
            } else if (value.equals("warn")) {
                config.setSemicolonInsertionMode(JoocOptions.SemicolonInsertionMode.WARN);
            } else if (value.equals("quirks")) {
                config.setSemicolonInsertionMode(JoocOptions.SemicolonInsertionMode.QUIRKS);
            } else {
                throw new IllegalArgumentException(new StringBuffer().append("unknown -autosemicolon argument: ").append(value).toString());
            }
        }
        if (line.hasOption(debugOption.getOpt())) {
            String[] values = line.getOptionValues(debugOption.getOpt());
            config.setDebug(true);
            if (values == null || values.length == 0) {
                config.setDebugLines(true);
                config.setDebugSource(true);
            } else {
                for (String value : values) {
                    if (value.equals("source")) {
                        config.setDebugSource(true);
                        continue;
                    }
                    if (value.equals("lines")) {
                        config.setDebugLines(true);
                        continue;
                    }
                    if (value.equals("none")) {
                        config.setDebug(false);
                        config.setDebugSource(false);
                        config.setDebugLines(false);
                        continue;
                    }
                    throw new IllegalArgumentException(new StringBuffer().append("unknown -g argument: ").append(value).toString());
                }
            }
        } else {
            config.setDebugSource(false);
            config.setDebugLines(true);
        }
        if (config.isVerbose()) {
            System.out.println(new StringBuffer().append("-genarateapi: ").append(config.isGenerateApi()).toString());
            System.out.println("-g option values:");
            System.out.println(new StringBuffer().append("source=").append(config.isDebugSource()).toString());
            System.out.println(new StringBuffer().append("lines=").append(config.isDebugLines()).toString());
        }
        if ((fileNames = line.getArgs()).length == 0) {
            this.printHelp(options);
            return null;
        }
        for (String fileName : fileNames) {
            config.addSourceFile(fileName);
        }
        return config;
    }

    private List<File> parsePath(CommandLine line, Option opt) {
        String sourcePathString;
        if (line.hasOption(opt.getOpt()) && !(sourcePathString = line.getOptionValue(opt.getOpt()).trim()).isEmpty()) {
            String[] sourceDirs = sourcePathString.split(new StringBuffer().append("\\Q").append(File.pathSeparatorChar).append("\\E").toString());
            ArrayList<File> sourcePathFiles = new ArrayList<File>(sourceDirs.length);
            for (String sourceDirPath : sourceDirs) {
                File sourceDir = new File(sourceDirPath.replace('/', File.separatorChar));
                if (!sourceDir.exists()) {
                    throw new IllegalArgumentException(new StringBuffer().append("directory or file does not exist: ").append(sourceDir.getAbsolutePath()).toString());
                }
                sourcePathFiles.add(sourceDir);
            }
            return sourcePathFiles;
        }
        return new ArrayList<File>();
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("jooc [options] <file> ...", options);
    }

    public static class CommandLineParseException
    extends Exception {
        private int exitCode;

        public CommandLineParseException(String message, int exitCode) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

