/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Expr;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;

class ConditionalExpr
extends Expr {
    Expr cond;
    JooSymbol symQuestion;
    Expr ifTrue;
    JooSymbol symColon;
    Expr ifFalse;

    public ConditionalExpr(Expr cond, JooSymbol symQuestion, Expr ifTrue, JooSymbol symColon, Expr ifFalse) {
        this.cond = cond;
        this.symQuestion = symQuestion;
        this.ifTrue = ifTrue;
        this.symColon = symColon;
        this.ifFalse = ifFalse;
    }

    public void scope(Scope scope) {
        this.cond.scope(scope);
        this.ifTrue.scope(scope);
        this.ifFalse.scope(scope);
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        this.cond.generateCode(out);
        out.writeSymbol(this.symQuestion);
        this.ifTrue.generateCode(out);
        out.writeSymbol(this.symColon);
        this.ifFalse.generateCode(out);
    }

    public Expr analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.cond = this.cond.analyze(this, context);
        this.ifTrue = this.ifTrue.analyze(this, context);
        this.ifFalse = this.ifFalse.analyze(this, context);
        return this;
    }

    public JooSymbol getSymbol() {
        return this.cond.getSymbol();
    }

    boolean isCompileTimeConstant() {
        return this.cond.isCompileTimeConstant() && this.ifTrue.isCompileTimeConstant() && this.ifFalse.isCompileTimeConstant();
    }

    public /* synthetic */ AstNode analyze(AstNode x0, AnalyzeContext x1) {
        return this.analyze(x0, x1);
    }
}

