/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.BlockStatement;
import net.jangaroo.jooc.Catch;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.KeywordStatement;
import net.jangaroo.jooc.Scope;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TryStatement
extends KeywordStatement {
    BlockStatement block;
    List<Catch> catches;
    JooSymbol symFinally;
    BlockStatement finallyBlock;

    public TryStatement(JooSymbol symTry, BlockStatement block, List<Catch> catches) {
        this(symTry, block, catches, null, null);
    }

    public TryStatement(JooSymbol symTry, BlockStatement block, List<Catch> catches, JooSymbol symFinally, BlockStatement finallyBlock) {
        super(symTry);
        this.block = block;
        this.catches = catches;
        this.symFinally = symFinally;
        this.finallyBlock = finallyBlock;
    }

    @Override
    public void scope(Scope scope) {
        this.block.scope(scope);
        this.scope(this.catches, scope);
        if (this.finallyBlock != null) {
            this.finallyBlock.scope(scope);
        }
    }

    @Override
    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        this.block.analyze(this, context);
        this.catches = this.analyze(this, this.catches, context);
        if (this.finallyBlock != null) {
            this.finallyBlock.analyze(this, context);
        }
        return this;
    }

    @Override
    protected void generateJsCode(JsWriter out) throws IOException {
        super.generateJsCode(out);
        this.block.generateCode(out);
        this.generateCode(this.catches, out);
        if (this.symFinally != null) {
            out.writeSymbol(this.symFinally);
            this.finallyBlock.generateCode(out);
        }
    }
}

