/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.CommaSeparatedList;
import net.jangaroo.jooc.CompilationUnit;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.LiteralExpr;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Scope;

class AnnotationParameter
extends NodeImplBase {
    Ide optName;
    JooSymbol optSymEq;
    LiteralExpr value;
    private CompilationUnit compilationUnit;

    public AnnotationParameter(Ide optName, JooSymbol optSymEq, LiteralExpr value) {
        this.optName = optName;
        this.optSymEq = optSymEq;
        this.value = value;
    }

    public void scope(Scope scope) {
        if (this.value != null) {
            this.value.scope(scope);
            this.compilationUnit = scope.getCompilationUnit();
        }
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (this.value != null) {
            this.value = (LiteralExpr)this.value.analyze(this, context);
            String metaName = ((CommaSeparatedList)parentNode).parentNode.getSymbol().getText();
            if ("Embed".equals(metaName) && this.optName != null && "source".equals(this.optName.getName())) {
                JooSymbol valueSymbol = this.value.getSymbol();
                String text = valueSymbol.getText();
                String quote = text.substring(0, 1);
                String source = (String)valueSymbol.getJooValue();
                String absoluteSource = this.compilationUnit.addResourceDependency(source);
                this.value.value = new JooSymbol(valueSymbol.sym, valueSymbol.getFileName(), valueSymbol.getLine(), valueSymbol.getColumn(), valueSymbol.getWhitespace(), quote + absoluteSource + quote, absoluteSource);
            }
        }
        return this;
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        if (this.optName != null && this.optSymEq != null) {
            this.optName.generateCode(out);
            out.writeSymbol(this.optSymEq);
        }
        this.value.generateCode(out);
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        if (this.optName != null && this.optSymEq != null) {
            this.optName.generateCode(out);
            out.writeSymbolWhitespace(this.optSymEq);
        } else {
            out.writeToken("$value");
        }
        out.writeToken(":");
        this.value.generateCode(out);
    }

    public JooSymbol getSymbol() {
        return this.optName == null ? this.value.getSymbol() : this.optName.getSymbol();
    }
}

